/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.microej.kf.util;

import java.util.Date;

import ej.kf.Converter;
import ej.kf.Feature;
import ej.kf.Kernel;

/**
 * A {@link Converter} for {@link Date}. This converter creates a clone of the original {@link Date}.
 */
public class DateConverter implements Converter<Date> {

	@Override
	public Date convert(Date arg0, Feature targetOwner) throws IllegalAccessError {
		try {
			return Kernel.clone(arg0, targetOwner);
		} catch (CloneNotSupportedException e) {
			// should not occur
			throw new AssertionError();
		}
	}

	@Override
	public Class<Date> getType() {
		return Date.class;
	}

}