/*
 * Java
 *
 * Copyright 2022 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.basictool.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation used to extend an existing class with new methods.
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface Extend {

	/**
	 * The name of the class to extend.
	 */
	String className();

	/**
	 * Declares whether the annotated method should remain {@code static} or not.
	 * <p>
	 * When not set, or {@code false}, the method will be injected in target class as an instance method (i.e. not
	 * static) and its first argument will be removed and used as receiver.
	 *
	 * @return {@code true} if the extended method is static, {@code false} otherwise
	 */
	boolean isStatic() default false;
}
