/*
 * Java
 *
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microvg.paint;

/**
 * Color visitor that changes color's opacity.
 */
public class OpacityVisitor implements PaintVisitor {

	private final int alpha;

	/**
	 * Creates an opacity transformer.
	 *
	 * @param alpha
	 *            the opacity to apply
	 */
	public OpacityVisitor(int alpha) {
		this.alpha = alpha;
	}

	@Override
	public int visitColor(int color) {
		return (this.alpha != VGPaint.ALPHA_FULLY_OPAQUE) ? VGPaint.applyOpacity(color, this.alpha) : color;
	}

}
