/*
 * Java
 *
 * Copyright 2018-2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.microej.kf.util;

import java.util.ArrayList;
import java.util.List;

import ej.kf.Converter;
import ej.kf.Feature;
import ej.kf.Kernel;

/**
 * A {@link Converter} for {@link List}. This converter creates a clone of the original {@link List}, and convert is
 * called for values.
 *
 * @param <E>
 *            the type of elements in this list
 */
public class ListConverter<E> implements Converter<List<E>> {

	@Override
	@SuppressWarnings({ "unchecked" })
	public Class<List<E>> getType() {
		// this construct is mandatory because of type erasure for class litterals
		return (Class<List<E>>) (Object) List.class;
	}

	@Override
	public List<E> convert(List<E> list, Feature targetOwner) throws IllegalAccessError {
		final int size = list.size();
		// clone map and strings
		RunnableWithResult<List<E>> runnable = new RunnableWithResult<List<E>>() {
			@Override
			public List<E> runWithResult() {
				return new ArrayList<>(size);
			}
		};
		Kernel.runUnderContext(targetOwner, runnable);
		List<E> result = runnable.getResult();
		for (E e : list) {
			E elt = (e == null) ? null : KernelSupport.clone(e, targetOwner);
			result.add(elt);
		}
		return result;
	}
}
