/*
 * Java
 *
 * Copyright 2013-2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.kf;

/**
 * This exception is thrown if a Feature being loaded is not compatible with the current Kernel.
 * @see Kernel#load(java.io.InputStream) 
 */
public class IncompatibleFeatureException extends Exception{

	/**
	 * Get the expected version of the Kernel on which this Feature can be installed 
	 * @return the expected Kernel version
	 * @see Kernel#getVersion()
	 */
	public String getExpectedKernelVersion(){
		throw new RuntimeException();
	}
}
