/*
 * Java
 *
 * Copyright 2013-2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.kf;

/**
 * This exception is thrown if a Feature being loaded has already been loaded.
 * @see Kernel#load(java.io.InputStream) 
 */
public class AlreadyLoadedFeatureException extends Exception{

	/**
	 * Creates an {@link AlreadyLoadedFeatureException} with the previously loaded {@link Feature}.
	 * @param feature the previously loaded {@link Feature}
	 */
	public AlreadyLoadedFeatureException(Feature feature){
		throw new RuntimeException();
	}
	
	/**
	 * Returns the previously loaded {@link Feature}.
	 * @return the previously loaded {@link Feature}.
	 */
	public Feature getFeature(){
		throw new RuntimeException();
	}
}
