/*
 * Java
 *
 * Copyright 2011-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.sp;

/**
 * The <code>SPWriter</code> interface provides a method for serializing objects into a block.
 */
public interface SPWriter {

	/**
	 * Writes an object into a block of the given {@link ShieldedPlug}. The class implementing this interface defines
	 * how the object is written.
	 *
	 * @param sp
	 *            the {@link ShieldedPlug} into which data is written
	 * @param blockID
	 *            ID of the block
	 * @param o
	 *            the object to be written
	 * @throws IllegalArgumentException
	 *             if no block is defined with the given ID
	 * @throws IndexOutOfBoundsException
	 *             if the block length is lower than the size needed for object serialization
	 */
	public void writeObject(ShieldedPlug sp, int blockID, Object o);

}
