/*
 * Java
 *
 * Copyright 2020-2025 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microvg.image;

import java.awt.Color;

/**
 * Represents a linear gradient.
 * <p>
 * The implementations and instances of this interface are provided by the image generator engine.
 */
public interface LinearGradient {

	/**
	 * Gets the start point X-coordinate.
	 *
	 * @return the X-coordinate.
	 */
	float getXStart();

	/**
	 * Gets the start point Y-coordinate.
	 *
	 * @return the Y-coordinate.
	 */
	float getYStart();

	/**
	 * Gets the end point X-coordinate.
	 *
	 * @return the X-coordinate.
	 */
	float getXEnd();

	/**
	 * Gets the start point Y-coordinate.
	 *
	 * @return the Y-coordinate.
	 */
	float getYEnd();

	/**
	 * Gets the linear gradient's stops (color and position).
	 *
	 * @return the stops.
	 */
	LinearGradientStop[] getStops();

	/**
	 * Represents a step of a linear gradient.
	 */
	interface LinearGradientStop {

		/**
		 * Gets the opacity of the color.
		 *
		 * @return a value between 0f and 1f
		 */
		float getOpacity();

		/**
		 * Gets the color position.
		 *
		 * @return a value between 0f and 1f
		 */
		float getPosition();

		/**
		 * Gets the color.
		 *
		 * @return the color.
		 */
		Color getColor();

	}

}
