/*
 * Copyright 2024-2025 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.audio;

import java.io.Closeable;

/**
 * Represents an audio recording stream.
 * <p>
 * An audio record allocates a native buffer when it is opened. The audio record should be closed with the
 * {@link #close()} method in order to free the native allocation.
 * <p>
 * While the audio record is open, the native implementation records audio data continuously from the input device and
 * writes it in the buffer. The {@link #readBuffer(byte[], int, int)} method can be used to retrieve and remove a chunk
 * of audio data from the buffer. If the audio data is not read fast enough by the application, the native
 * implementation will discard the oldest audio data from the buffer.
 */
public class AudioRecord implements Closeable {

	/**
	 * Creates and opens an audio record.
	 *
	 * @param format
	 *            the format.
	 * @param bufferSize
	 *            the buffer size (in bytes).
	 * @throws IllegalArgumentException
	 *             if the given buffer size is less than or equal to zero.
	 * @throws AudioException
	 *             if the audio record could not be opened.
	 * @throws SecurityException
	 *             if a security manager exists and does not allow the caller to create an audio record.
	 */
	public AudioRecord(AudioFormat format, int bufferSize) {
		throw new RuntimeException();
	}

	/**
	 * Returns the format of this audio record.
	 *
	 * @return the format.
	 */
	public AudioFormat getFormat() {
		throw new RuntimeException();
	}

	/**
	 * Returns the buffer size of this audio record.
	 *
	 * @return the buffer size (in bytes).
	 */
	public int getBufferSize() {
		throw new RuntimeException();
	}

	/**
	 * Returns whether this audio record is closed.
	 *
	 * @return whether this audio record is closed.
	 */
	public boolean isClosed() {
		throw new RuntimeException();
	}

	/**
	 * Closes this audio record.
	 * <p>
	 * This method releases the native resources allocated when opening this audio record. This method does nothing if
	 * this audio record is already closed.
	 */
	@Override
	public void close() {
		throw new RuntimeException();
	}

	/**
	 * Reads audio data from the buffer of this audio record.
	 * <p>
	 * This method blocks until the requested size has been read, until this audio record is closed or until the thread
	 * is interrupted.
	 * <p>
	 * The number of bytes read may be different from the given size if this audio record is closed or if the thread is
	 * interrupted.
	 *
	 * @param array
	 *            the array that will contain the data read.
	 * @param offset
	 *            the offset in the array of the first byte read.
	 * @param size
	 *            the maximum number of bytes to read.
	 * @return the number of bytes read.
	 * @throws IndexOutOfBoundsException
	 *             if the given offset or the given size is invalid.
	 * @throws SecurityException
	 *             if a security manager exists and does not allow the caller to read from the buffer.
	 */
	public int readBuffer(byte[] array, int offset, int size) {
		throw new RuntimeException();
	}
}
