/*
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.fp;

/**
 * A listener can modify the front panel window (by adding widgets, or other information).
 * <p>
 * This interface can be fully implemented by a dedicated class in a front panel project.
 */
public interface FrontPanelListener {

	/**
	 * Notifies that the front panel is starting.
	 */
	void onStart();

	/**
	 * Notifies that the front panel is stopping.
	 */
	void onStop();

}
