/**
 * Java
 *
 * Copyright 2014-2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.motion.util;

/**
 * Helper to simulate quick user swipes.
 * <p>
 * A swipe is when a user presses, moves quickly, then releases. This helper helps to continue the dynamic of this
 * movement. It needs to be coupled with a motion depending on the expected effect.
 */
public class TossHelper {

	private static final long SECOND = 1000;

	private TossHelper() {
	}

	/**
	 * Computes the expected stop considering the start value and the initial speed.
	 *
	 * @param start
	 *            the start value.
	 * @param speed
	 *            the initial speed.
	 * @param duration
	 *            the expected duration.
	 *
	 * @return the expected stop.
	 */
	public static int computeExpectedStop(int start, float speed, long duration) {
		// System.out.println("TossHelper.computeExpectedStop()");
		// System.out.println("start=" + start);
		// System.out.println("speed=" + speed);
		// System.out.println("duration=" + duration);
		// System.out.println("Result=" + (int) (start + speed * duration / SECOND));
		return (int) (start + speed * duration / SECOND);
	}

	/**
	 * Chooses the nearest step as stop.
	 *
	 * @param start
	 *            the start value.
	 * @param steps
	 *            the steps values.
	 * @param speed
	 *            the initial speed.
	 * @param duration
	 *            the expected duration.
	 * @return the step to stop at.
	 */
	public static int computeStop(int start, int[] steps, float speed, long duration) {
		int stop = start;
		int expectedStop = computeExpectedStop(start, speed, duration);
		long shift = Long.MAX_VALUE; // long to manage possible integer subtraction overflow
		// System.out.println("TossHelper.computeStop()");
		// System.out.println("shift=" + shift);
		// System.out.println("stop=" + stop);
		for (int step : steps) {
			long stepShift = Math.abs((long) step - expectedStop);
			// System.out.println("stepShift=" + stepShift);
			if (stepShift < shift) {
				shift = stepShift;
				stop = step;
			}
		}
		return stop;
	}

}
