/*
 * Decompiled with CFR 0.152.
 */
package ej.util;

import ej.bon.Constants;
import ej.sni.SNI;
import ej.util.DeviceNatives;

public class Device {
    private static final String BUFFER_SIZE_CONSTANT_NAME = "ej.device.buffer.size";
    private static final int BUFFER_SIZE = Constants.getInt((String)"ej.device.buffer.size");

    private Device() {
    }

    public static String getArchitecture() {
        byte[] buffer = new byte[BUFFER_SIZE];
        if (!DeviceNatives.getArchitecture(buffer, buffer.length)) {
            throw new IllegalArgumentException();
        }
        return SNI.toJavaString((byte[])buffer);
    }

    public static byte[] getId() {
        byte[] buffer = new byte[BUFFER_SIZE];
        int idSize = DeviceNatives.getId(buffer, buffer.length);
        if (idSize <= 0) {
            throw new IllegalArgumentException();
        }
        byte[] id = new byte[idSize];
        System.arraycopy(buffer, 0, id, 0, idSize);
        return id;
    }

    public static String getVersion() {
        byte[] buffer = new byte[BUFFER_SIZE];
        DeviceNatives.getVersion(buffer);
        return SNI.toJavaString((byte[])buffer);
    }

    public static void reboot() {
        DeviceNatives.reboot();
    }

    public static void shutdown() {
        DeviceNatives.shutdown();
    }
}

