/*
 * Decompiled with CFR 0.152.
 */
package ej.websocket;

public class WebSocketURI {
    private static final String DEFAULT_RESOURCE_NAME = "/";
    public static final int DEFAULT_NOT_SECURE_PORT = 80;
    public static final int DEFAULT_SECURE_PORT = 443;
    private final String host;
    private final int port;
    private final String resourceName;
    private final boolean secureFlag;

    public WebSocketURI(String host, int port, String resourceName, boolean isSecure) throws IllegalArgumentException {
        if (host == null || host.isEmpty() || port == 0 || resourceName == null) {
            throw new IllegalArgumentException();
        }
        this.host = host;
        this.port = port;
        this.resourceName = resourceName.startsWith(DEFAULT_RESOURCE_NAME) ? resourceName : DEFAULT_RESOURCE_NAME + resourceName;
        this.secureFlag = isSecure;
    }

    public WebSocketURI(String host, int port, String resourceName) throws IllegalArgumentException {
        this(host, port, resourceName, false);
    }

    public WebSocketURI(String host, String resourceName) throws IllegalArgumentException {
        this(host, 80, resourceName);
    }

    public WebSocketURI(String host, int port) throws IllegalArgumentException {
        this(host, port, DEFAULT_RESOURCE_NAME);
    }

    public WebSocketURI(String host) throws IllegalArgumentException {
        this(host, 80, DEFAULT_RESOURCE_NAME);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public boolean isSecure() {
        return this.secureFlag;
    }

    public String toString() {
        String prefix = this.secureFlag ? "wss://" : "ws://";
        return String.valueOf(prefix) + this.host + ":" + this.port + this.resourceName;
    }
}

