/*
 * Decompiled with CFR 0.152.
 */
package ej.net.util.connectivity;

import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import ej.annotation.NonNull;

public final class ConnectivityUtil {
    private ConnectivityUtil() {
    }

    public static void registerAndCall(@NonNull ConnectivityManager manager, @NonNull ConnectivityManager.NetworkCallback callback) {
        manager.registerDefaultNetworkCallback(callback);
        ConnectivityUtil.callCurrentState(manager, callback);
    }

    public static void callCurrentState(@NonNull ConnectivityManager manager, @NonNull ConnectivityManager.NetworkCallback callback) {
        Network activeNetwork = manager.getActiveNetwork();
        NetworkInfo networkInfo = manager.getNetworkInfo(activeNetwork);
        NetworkCapabilities capability = manager.getNetworkCapabilities(activeNetwork);
        if (networkInfo != null && networkInfo.isConnected()) {
            callback.onAvailable(activeNetwork);
        } else {
            callback.onLost(activeNetwork);
        }
        if (capability != null) {
            callback.onCapabilitiesChanged(activeNetwork, capability);
        }
    }
}

