/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.motion;

import ej.bon.Util;
import ej.motion.Motion;
import ej.mwt.animation.Animation;
import ej.mwt.animation.Animator;
import ej.widget.motion.MotionAnimationListener;

public class MotionAnimation {
    private final Animator animator;
    private final Motion motion;
    private final MotionAnimationListener listener;
    private final Animation animation;
    private long startTime;
    private int lastValue;

    public MotionAnimation(Animator animator, Motion motion, MotionAnimationListener listener) {
        this.animator = animator;
        this.motion = motion;
        this.listener = listener;
        this.animation = new Animation(){

            public boolean tick(long currentTimeMillis) {
                return MotionAnimation.this.tick(currentTimeMillis);
            }
        };
    }

    public void start() {
        this.startTime = Util.platformTimeMillis();
        this.lastValue = this.motion.getStartValue();
        this.animator.startAnimation(this.animation);
    }

    public void stop() {
        this.animator.stopAnimation(this.animation);
    }

    private boolean tick(long currentTimeMillis) {
        long elapsedTime = currentTimeMillis - this.startTime;
        boolean finished = elapsedTime >= this.motion.getDuration();
        int value = this.motion.getValue(elapsedTime);
        if (value != this.lastValue || finished) {
            this.listener.tick(value, finished);
            this.lastValue = value;
        }
        return !finished;
    }
}

