/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import ej.annotation.Nullable;
import java.io.IOException;
import java.io.Writer;

public class BufferedWriter
extends Writer {
    @Nullable
    private Writer out;
    @Nullable
    private char[] cb;
    private final int nChars;
    private int nextChar;
    private static int defaultCharBufferSize = 8192;
    private final String lineSeparator;

    public BufferedWriter(Writer out) {
        this(out, defaultCharBufferSize);
    }

    public BufferedWriter(Writer out, int sz) {
        super((Object)out);
        if (sz <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.out = out;
        this.cb = new char[sz];
        this.nChars = sz;
        this.nextChar = 0;
        String lineSeparator = System.getProperty("line.separator");
        assert (lineSeparator != null);
        this.lineSeparator = lineSeparator;
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            Writer out = this.out;
            assert (out != null);
            char[] cb = this.cb;
            assert (cb != null);
            if (this.nextChar == 0) {
                return;
            }
            out.write(cb, 0, this.nextChar);
            this.nextChar = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.nextChar >= this.nChars) {
                this.flushBuffer();
            }
            char[] cb = this.cb;
            assert (cb != null);
            cb[this.nextChar++] = (char)c;
        }
    }

    private int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            Writer out = this.out;
            assert (out != null);
            char[] cb = this.cb;
            assert (cb != null);
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            if (len >= this.nChars) {
                this.flushBuffer();
                out.write(cbuf, off, len);
                return;
            }
            int b = off;
            int t = off + len;
            while (b < t) {
                int d = this.min(this.nChars - this.nextChar, t - b);
                System.arraycopy(cbuf, b, cb, this.nextChar, d);
                b += d;
                this.nextChar += d;
                if (this.nextChar < this.nChars) continue;
                this.flushBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String s, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            char[] cb = this.cb;
            assert (cb != null);
            int b = off;
            int t = off + len;
            while (b < t) {
                int d = this.min(this.nChars - this.nextChar, t - b);
                s.getChars(b, b + d, cb, this.nextChar);
                b += d;
                this.nextChar += d;
                if (this.nextChar < this.nChars) continue;
                this.flushBuffer();
            }
        }
    }

    public void newLine() throws IOException {
        this.write(this.lineSeparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            Writer out = this.out;
            assert (out != null);
            this.flushBuffer();
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            Writer out = this.out;
            if (out == null) {
                return;
            }
            try {
                Throwable throwable = null;
                Object var4_5 = null;
                try (Writer w = out;){
                    this.flushBuffer();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                this.out = null;
                this.cb = null;
            }
        }
    }
}

