/*
 * Decompiled with CFR 0.152.
 */
package ej.fp.widget.display.buffer;

import ej.fp.FrontPanel;
import ej.fp.Image;
import ej.fp.Widget;
import ej.fp.widget.display.DisplayBufferManager;
import ej.fp.widget.display.buffer.DisplayBufferPolicy;
import ej.microui.display.Rectangle;

public abstract class SwapBufferPolicy
implements DisplayBufferPolicy {
    private final int bufferCount;
    private Widget displayWidget;
    private Image[] buffers;
    private int backBuffer;

    public SwapBufferPolicy(int bufferCount) {
        this.bufferCount = bufferCount;
        if (bufferCount <= 1) {
            throw new IllegalArgumentException("This buffer manager can only handle at least 2 buffers.");
        }
    }

    @Override
    public void setDisplayProperties(Widget displayWidget, int width, int height, int initialColor) {
        this.displayWidget = displayWidget;
        this.buffers = new Image[this.bufferCount];
        int i = 0;
        while (i < this.bufferCount) {
            this.buffers[i] = FrontPanel.getFrontPanel().newImage(width, height, initialColor, false);
            ++i;
        }
    }

    @Override
    public int getBufferCount() {
        return this.buffers.length;
    }

    @Override
    public boolean isDoubleBuffered() {
        return true;
    }

    @Override
    public void flush(DisplayBufferManager bufferManager, Rectangle[] rectangles) {
        this.swap();
        this.displayWidget.repaint();
        bufferManager.simulateFlushTime();
    }

    private void swap() {
        this.backBuffer = (this.backBuffer + 1) % this.buffers.length;
    }

    @Override
    public Image getBackBuffer() {
        return this.buffers[this.backBuffer];
    }

    @Override
    public Image getFrontBuffer() {
        return this.buffers[this.getPreviousBuffer()];
    }

    private int getPreviousBuffer() {
        int count = this.buffers.length;
        return (this.backBuffer - 1 + count) % count;
    }

    @Override
    public void dispose() {
        FrontPanel.getFrontPanel().disposeIfNotNull(this.buffers);
    }
}

