/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.style.background;

import ej.annotation.Nullable;
import ej.microui.display.GraphicsContext;
import ej.microui.display.Image;
import ej.microui.display.Painter;
import ej.mwt.style.background.Background;
import ej.mwt.util.Alignment;

public class ImageBackground
implements Background {
    private final Image image;
    private final byte horizontalAlignment;
    private final byte verticalAlignment;

    public ImageBackground(Image image) {
        this(image, 0, 3);
    }

    public ImageBackground(Image image, int horizontalAlignment, int verticalAlignment) {
        Alignment.validateHorizontalAlignment(horizontalAlignment);
        Alignment.validateVerticalAlignment(verticalAlignment);
        this.image = image;
        this.horizontalAlignment = (byte)horizontalAlignment;
        this.verticalAlignment = (byte)verticalAlignment;
    }

    @Override
    public boolean isTransparent(int width, int height) {
        Image image = this.image;
        return image.isTransparent() || image.getWidth() < width || image.getHeight() < height;
    }

    @Override
    public void apply(GraphicsContext g, int width, int height) {
        Image image = this.image;
        int x = Alignment.computeLeftX(image.getWidth(), 0, width, this.horizontalAlignment);
        int y = Alignment.computeTopY(image.getHeight(), 0, height, this.verticalAlignment);
        Painter.drawImage((GraphicsContext)g, (Image)image, (int)x, (int)y);
        g.removeBackgroundColor();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof ImageBackground) {
            ImageBackground background = (ImageBackground)obj;
            return this.image == background.image && this.horizontalAlignment == background.horizontalAlignment && this.verticalAlignment == background.verticalAlignment;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.horizontalAlignment * this.verticalAlignment;
    }
}

