/*
 * Decompiled with CFR 0.152.
 */
package ej.bluetooth.util.services.cts;

import ej.bluetooth.BluetoothAttribute;
import ej.bluetooth.BluetoothCharacteristic;
import ej.bluetooth.BluetoothConnection;
import ej.bluetooth.BluetoothService;
import ej.bluetooth.listeners.LocalServiceListener;
import ej.bluetooth.listeners.impl.DefaultLocalServiceListener;
import ej.bluetooth.util.AttributeNotFoundException;
import ej.bluetooth.util.ServiceHelper;
import ej.bluetooth.util.services.cts.CurrentTimeConstants;
import ej.bon.ByteArray;
import java.util.Calendar;

public class CurrentTimeServer
extends DefaultLocalServiceListener {
    private final BluetoothService service;
    private final BluetoothCharacteristic currentTimeChar;
    private final BluetoothCharacteristic localTimeInfoChar;

    public CurrentTimeServer(BluetoothService service) {
        this.service = service;
        try {
            this.currentTimeChar = ServiceHelper.getCharacteristic(service, CurrentTimeConstants.CURRENT_TIME_UUID);
            this.localTimeInfoChar = ServiceHelper.getCharacteristic(service, CurrentTimeConstants.LOCAL_TIME_INFO_UUID);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw new IllegalArgumentException("Invalid current time service");
        }
    }

    public void start() {
        this.service.setLocalListener((LocalServiceListener)this);
    }

    public void stop() {
        this.service.setLocalListener((LocalServiceListener)new DefaultLocalServiceListener());
    }

    public void onReadRequest(BluetoothConnection connection, BluetoothAttribute attribute) {
        if (attribute == this.currentTimeChar) {
            connection.sendReadResponse(attribute, (byte)0, CurrentTimeServer.makeCurrentTime());
        } else if (attribute == this.localTimeInfoChar) {
            connection.sendReadResponse(attribute, (byte)0, CurrentTimeServer.makeLocalTimeInfo());
        } else {
            super.onReadRequest(connection, attribute);
        }
    }

    private static byte[] makeCurrentTime() {
        Calendar calendar = Calendar.getInstance();
        int localTimeOffset = calendar.get(15) + calendar.get(16);
        calendar.set(14, calendar.get(14) - localTimeOffset);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        int dayOfWeek = calendar.get(7);
        dayOfWeek = dayOfWeek == 1 ? 7 : --dayOfWeek;
        int fractionsOfSecond = (int)(calendar.getTimeInMillis() * 256L / 1000L);
        boolean adjustReason = false;
        byte[] value = new byte[10];
        ByteArray.writeShort((byte[])value, (int)0, (int)year, (int)0);
        value[2] = (byte)month;
        value[3] = (byte)day;
        value[4] = (byte)hour;
        value[5] = (byte)minute;
        value[6] = (byte)second;
        value[7] = (byte)dayOfWeek;
        value[8] = (byte)fractionsOfSecond;
        value[9] = (byte)(adjustReason ? 1 : 0);
        return value;
    }

    private static byte[] makeLocalTimeInfo() {
        Calendar calendar = Calendar.getInstance();
        int timezoneOffset = calendar.get(15) / 900000;
        int dstOffset = calendar.get(16) / 900000;
        byte[] value = new byte[]{(byte)timezoneOffset, (byte)dstOffset};
        return value;
    }
}

