/*
 * Decompiled with CFR 0.152.
 */
package ej.bluetooth.util;

import ej.annotation.Nullable;
import ej.bluetooth.BluetoothUuid;
import ej.bluetooth.util.Messages;
import ej.bon.ByteArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdvertisementData {
    private static final int MAX_DATA_SIZE = 31;
    private byte flags = (byte)6;
    @Nullable
    private String deviceName = null;
    private short appearance = 0;
    private final Map<Short, byte[]> manufacturerData = new HashMap<Short, byte[]>();
    private final List<BluetoothUuid> serviceUuids = new ArrayList<BluetoothUuid>();

    public byte getFlags() {
        return this.flags;
    }

    @Nullable
    public String getDeviceName() {
        return this.deviceName;
    }

    public short getAppearance() {
        return this.appearance;
    }

    @Nullable
    public byte[] getManufacturerData(int manufacturerId) {
        byte[] data = this.manufacturerData.get((short)manufacturerId);
        return data == null ? null : Arrays.copyOf(data, data.length);
    }

    public int getNumServiceUuids() {
        return this.serviceUuids.size();
    }

    public BluetoothUuid getServiceUuid(int index) {
        BluetoothUuid serviceUuid = this.serviceUuids.get(index);
        assert (serviceUuid != null);
        return serviceUuid;
    }

    public void setFlags(int flags) {
        this.flags = (byte)flags;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public void setAppearance(short appearance) {
        this.appearance = appearance;
    }

    public void addManufacturerData(int manufacturerId, byte[] data) {
        this.manufacturerData.put((short)manufacturerId, Arrays.copyOf(data, data.length));
    }

    public void addServiceUuid(BluetoothUuid serviceUuid) {
        if (!this.serviceUuids.contains(serviceUuid)) {
            this.serviceUuids.add(serviceUuid);
        }
    }

    public byte[] serialize() {
        byte[] data;
        byte[] buffer = new byte[31];
        int offset = 0;
        if (this.flags != 0) {
            offset = AdvertisementData.addField(buffer, offset, (byte)1, new byte[]{this.flags});
        }
        if (this.deviceName != null) {
            offset = AdvertisementData.addField(buffer, offset, (byte)9, this.deviceName.getBytes());
        }
        if (this.appearance != 0) {
            byte[] data2 = new byte[2];
            ByteArray.writeShort((byte[])data2, (int)0, (int)this.appearance, (int)0);
            offset = AdvertisementData.addField(buffer, offset, (byte)25, data2);
        }
        for (Map.Entry<Short, byte[]> entry : this.manufacturerData.entrySet()) {
            Short id = entry.getKey();
            Object value = entry.getValue();
            assert (id != null && value != null);
            byte[] data3 = new byte[2 + ((Object)value).length];
            ByteArray.writeShort((byte[])data3, (int)0, (int)id.shortValue(), (int)0);
            System.arraycopy(value, 0, data3, 2, ((Object)value).length);
            offset = AdvertisementData.addField(buffer, offset, (byte)-1, data3);
        }
        int num16BitUuids = 0;
        int num128BitUuids = 0;
        for (BluetoothUuid serviceUuid : this.serviceUuids) {
            assert (serviceUuid != null);
            if (serviceUuid.is16Bit()) {
                ++num16BitUuids;
                continue;
            }
            ++num128BitUuids;
        }
        if (num16BitUuids > 0) {
            data = new byte[num16BitUuids * 2];
            int uuidIndex = 0;
            for (BluetoothUuid serviceUuid : this.serviceUuids) {
                assert (serviceUuid != null);
                if (!serviceUuid.is16Bit()) continue;
                short uuid16 = serviceUuid.get16BitValue();
                ByteArray.writeShort((byte[])data, (int)(uuidIndex * 2), (int)uuid16, (int)0);
                ++uuidIndex;
            }
            offset = AdvertisementData.addField(buffer, offset, (byte)2, data);
        }
        if (num128BitUuids > 0) {
            data = new byte[num128BitUuids * 16];
            int uuidIndex = 0;
            for (BluetoothUuid serviceUuid : this.serviceUuids) {
                assert (serviceUuid != null);
                if (serviceUuid.is16Bit()) continue;
                byte[] uuid128 = new byte[16];
                serviceUuid.getBytes(uuid128, 0);
                AdvertisementData.swapEndianness(uuid128, data, uuidIndex * 16);
                ++uuidIndex;
            }
            offset = AdvertisementData.addField(buffer, offset, (byte)6, data);
        }
        return Arrays.copyOf(buffer, offset);
    }

    private static int addField(byte[] buffer, int offset, byte type, byte[] value) {
        if (offset + 2 + value.length > 31) {
            Messages.getLogger().log('W', "ej.bluetooth.util", -1);
            return offset;
        }
        buffer[offset] = (byte)(1 + value.length);
        buffer[offset + 1] = type;
        System.arraycopy(value, 0, buffer, offset + 2, value.length);
        return offset + 2 + value.length;
    }

    public static AdvertisementData parse(byte[] data) {
        AdvertisementData advertisementData = new AdvertisementData();
        int offset = 0;
        while (offset < data.length) {
            byte length = data[offset];
            if (length == 0 || offset + 1 + length > data.length) break;
            byte type = data[offset + 1];
            byte[] value = new byte[length - 1];
            System.arraycopy(data, offset + 2, value, 0, length - 1);
            AdvertisementData.parseField(type, value, advertisementData);
            offset += 1 + length;
        }
        return advertisementData;
    }

    private static void parseField(byte type, byte[] value, AdvertisementData advertisementData) {
        switch (type) {
            case 1: {
                if (value.length < 1) break;
                advertisementData.setFlags(value[0]);
                break;
            }
            case 8: 
            case 9: {
                advertisementData.setDeviceName(new String(value));
                break;
            }
            case 25: {
                if (value.length != 2) break;
                short appearance = ByteArray.readShort((byte[])value, (int)0, (int)0);
                advertisementData.setAppearance(appearance);
                break;
            }
            case -1: {
                if (value.length < 2) break;
                short manufacturerId = ByteArray.readShort((byte[])value, (int)0, (int)0);
                byte[] manufacturerData = Arrays.copyOfRange(value, 2, value.length);
                advertisementData.addManufacturerData(manufacturerId, manufacturerData);
                break;
            }
            case 2: 
            case 3: {
                if (value.length != 2) break;
                short uuid16 = ByteArray.readShort((byte[])value, (int)0, (int)0);
                advertisementData.addServiceUuid(new BluetoothUuid((int)uuid16));
                break;
            }
            case 6: 
            case 7: {
                if (value.length != 16) break;
                byte[] uuid128 = new byte[16];
                AdvertisementData.swapEndianness(value, uuid128, 0);
                advertisementData.addServiceUuid(new BluetoothUuid(uuid128, 0));
            }
        }
    }

    private static void swapEndianness(byte[] in, byte[] out, int outOffset) {
        int length = in.length;
        int i = 0;
        while (i < length) {
            out[outOffset + i] = in[length - 1 - i];
            ++i;
        }
    }
}

