/*
 * Decompiled with CFR 0.152.
 */
package ej.service;

import ej.annotation.Nullable;
import ej.service.MissingServiceException;
import ej.service.ServiceLoader;
import ej.service.ServiceRegistry;
import ej.service.loader.ServiceLoaderHelper;
import ej.service.loader.SystemPropertiesServiceLoader;
import ej.service.registry.SimpleServiceRegistry;

public class ServiceFactory {
    private static final ServiceRegistry SERVICE_REGISTRY = ServiceFactory.getServiceRegistryInstance();
    private static final ServiceLoader SERVICE_LOADER = ServiceFactory.getServiceLoaderInstance();

    private ServiceFactory() {
    }

    private static ServiceRegistry getServiceRegistryInstance() {
        SystemPropertiesServiceLoader propertiesServiceLoader = new SystemPropertiesServiceLoader();
        ServiceRegistry serviceRegistryCandidate = propertiesServiceLoader.getService(ServiceRegistry.class);
        if (serviceRegistryCandidate != null) {
            return serviceRegistryCandidate;
        }
        return new SimpleServiceRegistry();
    }

    private static ServiceLoader getServiceLoaderInstance() {
        SystemPropertiesServiceLoader propertiesServiceLoader = new SystemPropertiesServiceLoader();
        ServiceLoader serviceLoaderCandidate = propertiesServiceLoader.getService(ServiceLoader.class);
        if (serviceLoaderCandidate != null) {
            return serviceLoaderCandidate;
        }
        return propertiesServiceLoader;
    }

    public static ServiceLoader getServiceLoader() {
        return SERVICE_LOADER;
    }

    public static ServiceRegistry getServiceRegistry() {
        return SERVICE_REGISTRY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <T> T getService(Class<T> service) {
        Class<T> clazz = service;
        synchronized (clazz) {
            T result = SERVICE_LOADER.getService(service);
            if (result != null) {
                return result;
            }
            return SERVICE_REGISTRY.getService(service);
        }
    }

    public static <T> void register(Class<T> service, T instance) {
        SERVICE_REGISTRY.register(service, instance);
    }

    public static <T> void unregister(Class<T> service, T instance) {
        SERVICE_REGISTRY.unregister(service, instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getService(Class<T> service, Class<? extends T> defaultImplementation) {
        Class<T> clazz = service;
        synchronized (clazz) {
            T result = ServiceFactory.getService(service);
            if (result != null) {
                return result;
            }
            T instantiatedService = ServiceLoaderHelper.createClassInstance(service, defaultImplementation);
            SERVICE_REGISTRY.register(service, instantiatedService);
            return instantiatedService;
        }
    }

    public static <T> T getRequiredService(Class<T> service) {
        T instance = ServiceFactory.getService(service);
        if (instance == null) {
            String name = service.getName();
            throw new MissingServiceException(name);
        }
        return instance;
    }
}

