/*
 * Decompiled with CFR 0.152.
 */
package ej.fp;

import ej.fp.Composite;
import ej.fp.FrontPanel;
import ej.fp.Image;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class Widget {
    public static final String DEFAULT_LABEL = "";
    private String label = "";
    private int x;
    private int y;
    private int width;
    private int height;
    private Image skin;
    private Image filter;
    private boolean overlay;
    private Composite composite;
    private Image currentSkin;

    public void setLabel(String label) {
        this.label = label == null ? DEFAULT_LABEL : label;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setWidth(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("Widget width cannot be negative.");
        }
        this.width = width;
    }

    public void setHeight(int height) {
        if (height < 0) {
            throw new IllegalArgumentException("Widget height cannot be negative.");
        }
        this.height = height;
    }

    public void setSkin(Image skin) {
        this.skin = skin;
    }

    public void setFilter(Image filter) {
        this.filter = filter;
    }

    public final void setOverlay(boolean overlay) {
        this.overlay = overlay;
    }

    public synchronized void finalizeConfiguration() {
        Image filter;
        Image skin = this.getSkin();
        if (skin != null) {
            this.width = skin.getWidth();
            this.height = skin.getHeight();
        }
        if ((filter = this.filter) != null && (this.getHeight() != filter.getHeight() || this.getWidth() != filter.getWidth())) {
            throw new IllegalStateException("Filter image must have the same size than widget itself.");
        }
        this.currentSkin = this.skin;
    }

    public void showYourself(boolean appearSwitchedOn) {
    }

    public void start() {
    }

    public void dispose() {
        FrontPanel.getFrontPanel().disposeIfNotNull(this.skin, this.currentSkin, this.filter);
        this.skin = null;
        this.currentSkin = null;
        this.filter = null;
    }

    public String getLabel() {
        return this.label;
    }

    public Image getSkin() {
        return this.skin;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Image getFilter() {
        return this.filter;
    }

    public boolean isOver(int x, int y) {
        return this.isOverWidget(x, y) && this.isOverFilter(x, y);
    }

    public int getAbsoluteX() {
        Composite parent = this.getParent();
        return parent == null ? this.x : parent.getAbsoluteX() + this.x;
    }

    public int getAbsoluteY() {
        Composite parent = this.getParent();
        return parent == null ? this.y : parent.getAbsoluteY() + this.y;
    }

    public Composite getParent() {
        return this.composite;
    }

    public Image getCurrentSkin() {
        return this.currentSkin;
    }

    public void setCurrentSkin(Image skin) {
        this.currentSkin = skin;
        this.repaint();
    }

    public void repaint() {
        if (this.overlay) {
            FrontPanel.getFrontPanel().repaintWidget(this);
        } else {
            FrontPanel.getFrontPanel().repaintDevice(this.getAbsoluteX(), this.getAbsoluteY(), this.width, this.height);
        }
    }

    public void repaint(int x, int y, int width, int height) {
        if (this.overlay) {
            FrontPanel.getFrontPanel().repaintWidget(this, x, y, width, height);
        } else {
            FrontPanel.getFrontPanel().repaintDevice(this.getAbsoluteX() + x, this.getAbsoluteY() + y, width, height);
        }
    }

    void setParent(Composite composite) {
        this.composite = composite;
    }

    private boolean isOverWidget(int x, int y) {
        return this.x <= x && this.y <= y && this.x + this.width > x && this.y + this.height > y;
    }

    private boolean isOverFilter(int x, int y) {
        try {
            Image filter = this.filter;
            return filter == null || (filter.readPixel(x - this.getAbsoluteX(), y - this.getAbsoluteY()) & 0xFF000000) != 0;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface WidgetAttribute {
        public String name();

        public boolean isOptional() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface WidgetDescription {
        public WidgetAttribute[] attributes();
    }
}

