/*
 * Decompiled with CFR 0.152.
 */
package com.microej.net.test.util;

import com.microej.net.test.util.INetInit;
import ej.ecom.network.IPConfiguration;
import ej.ecom.network.NetworkInterfaceManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;

public class EthernetNetInit
implements INetInit {
    public static final String NETIF_NAME_PROPERTY = "netif.name";
    private static final String NETIF_CONF_PROP_IP = "netif.ip";
    private static final String NETIF_CONF_PROP_NETMASK = "netif.netmask";
    private static final String NETIF_CONF_PROP_GATEWAY = "netif.gateway";
    private static final String NETIF_CONF_PROP_DNS = "netif.dns";
    public static final String NETIF_NAME = System.getProperty("netif.name");
    public static final String NETIF_IP = System.getProperty("netif.ip");
    public static final String NETIF_NETMASK = System.getProperty("netif.netmask");
    public static final String NETIF_GATEWAY = System.getProperty("netif.gateway");
    public static final String NETIF_DNS = System.getProperty("netif.dns");

    @Override
    public void initialize() throws IOException {
        if (NETIF_NAME == null) {
            throw new RuntimeException("[ERROR] No network interface defined. Please set the system property 'netif.name'.");
        }
        this.startNetworkInterface(NETIF_NAME, NETIF_IP, NETIF_NETMASK, NETIF_GATEWAY, NETIF_DNS);
    }

    public void startNetworkInterface(String interfaceName, String staticIP, String netmask, String gateway, String dns) throws IOException {
        NetworkInterface netif = NetworkInterface.getByName(interfaceName);
        if (netif == null) {
            throw new IOException("No network interface \"" + interfaceName + "\" found");
        }
        if (!NetworkInterfaceManager.isStarted((NetworkInterface)netif)) {
            NetworkInterfaceManager.start((NetworkInterface)netif);
        }
        if (!NetworkInterfaceManager.isEnabled((NetworkInterface)netif)) {
            NetworkInterfaceManager.enable((NetworkInterface)netif);
        }
        IPConfiguration conf = new IPConfiguration();
        if (staticIP == null) {
            conf.useDHCP(true);
            if (dns != null) {
                conf.useStaticDNS(true);
                conf.setDNS(new InetAddress[]{InetAddress.getByName(dns)});
            }
        } else {
            conf.useDHCP(false);
            conf.setIP(InetAddress.getByName(staticIP));
            if (netmask != null) {
                conf.setNetmask(InetAddress.getByName(netmask));
            }
            if (gateway != null) {
                conf.setGateway(InetAddress.getByName(gateway));
            }
            if (dns != null) {
                conf.setDNS(new InetAddress[]{InetAddress.getByName(dns)});
            }
        }
        NetworkInterfaceManager.configure((NetworkInterface)netif, (IPConfiguration)conf);
    }
}

