/*
 * Decompiled with CFR 0.152.
 */
package ej.fp.widget;

import ej.fp.FrontPanel;
import ej.fp.Image;
import ej.fp.MouseListener;
import ej.fp.Widget;
import ej.fp.util.WidgetWithListener;
import ej.microui.event.EventButton;

@Widget.WidgetDescription(attributes={@Widget.WidgetAttribute(name="label"), @Widget.WidgetAttribute(name="x"), @Widget.WidgetAttribute(name="y"), @Widget.WidgetAttribute(name="skin"), @Widget.WidgetAttribute(name="pushedSkin"), @Widget.WidgetAttribute(name="filter", isOptional=true), @Widget.WidgetAttribute(name="listenerClass", isOptional=true)})
public class Button
extends WidgetWithListener
implements MouseListener {
    private Image pushedSkin;
    private ButtonListener listener;
    private int id;

    public void setLabel(String label) {
        super.setLabel(label);
        this.id = Integer.parseInt(this.getLabel());
    }

    public void setPushedSkin(Image pushedSkin) {
        this.pushedSkin = pushedSkin;
    }

    public void setListenerClass(String listenerClassName) {
        this.setListenerClass(ButtonListener.class, listenerClassName);
    }

    public void start() {
        super.start();
        this.listener = this.newListener(ButtonListener.class);
    }

    public void dispose() {
        FrontPanel.getFrontPanel().disposeIfNotNull(new Image[]{this.pushedSkin});
        this.pushedSkin = null;
        super.dispose();
    }

    @Override
    protected Object newDefaultListener() {
        return new ButtonListenerToButtonEvents();
    }

    public void mousePressed(int x, int y, MouseListener.MouseButton button) {
        if (button == MouseListener.MouseButton.FIRST_BUTTON) {
            this.press();
        }
    }

    public void mouseReleased(int x, int y, MouseListener.MouseButton button) {
        if (button == MouseListener.MouseButton.FIRST_BUTTON) {
            this.release();
        }
    }

    protected void press() {
        this.setCurrentSkin(this.pushedSkin);
        this.listener.press(this);
    }

    protected void release() {
        this.setCurrentSkin(this.getSkin());
        this.listener.release(this);
    }

    protected ButtonListener getListener() {
        return this.listener;
    }

    public Image getPushedSkin() {
        return this.pushedSkin;
    }

    public int getID() {
        return this.id;
    }

    public static interface ButtonListener {
        public void press(Button var1);

        public void release(Button var1);
    }

    public static class ButtonListenerToButtonEvents
    implements ButtonListener {
        @Override
        public void press(Button widget) {
            EventButton.sendPressedEvent((String)this.getMicroUIGeneratorTag(), (int)widget.getID());
        }

        @Override
        public void release(Button widget) {
            EventButton.sendReleasedEvent((String)this.getMicroUIGeneratorTag(), (int)widget.getID());
        }

        protected String getMicroUIGeneratorTag() {
            return "BUTTONS";
        }
    }
}

