/*
 * Decompiled with CFR 0.152.
 */
package ej.rcommand.impl;

import ej.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;

public class LimitedLengthInputStream
extends InputStream {
    private boolean eof;
    private int remainingLength;
    @Nullable
    private final InputStream in;
    static final int CHUNCKS_SIZE = Integer.getInteger("ej.rcommand.chunks.size", 2048);

    public LimitedLengthInputStream() {
        this.eof = true;
        this.in = null;
    }

    public LimitedLengthInputStream(InputStream in, int length) {
        if (length <= 0) {
            this.eof = true;
            this.in = null;
        } else {
            this.eof = false;
            this.in = in;
            this.remainingLength = length;
        }
    }

    @Override
    public int available() throws IOException {
        if (this.eof) {
            return 0;
        }
        return this.remainingLength;
    }

    @Override
    public void close() throws IOException {
        if (!this.eof) {
            byte[] chuncks = new byte[CHUNCKS_SIZE];
            while (this.read(chuncks) != -1) {
            }
            this.eof = true;
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        assert (this.in != null);
        int r = this.in.read();
        --this.remainingLength;
        if (r == -1 || this.remainingLength == 0) {
            this.eof = true;
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.eof) {
            return -1;
        }
        assert (this.in != null);
        int r = this.in.read(b, off, Math.min(this.remainingLength, len));
        this.remainingLength -= r;
        if (r == -1 || this.remainingLength == 0) {
            this.eof = true;
        }
        return r;
    }

    @Override
    public synchronized void reset() throws IOException {
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.eof) {
            return 0L;
        }
        assert (this.in != null);
        long r = this.in.skip(Math.min((long)this.remainingLength, n));
        this.remainingLength = (int)((long)this.remainingLength - r);
        if (this.remainingLength == 0) {
            this.eof = true;
        }
        return r;
    }
}

