/*
 * Decompiled with CFR 0.152.
 */
package ej.bluetooth.util.server;

import ej.annotation.NonNull;
import ej.annotation.Nullable;
import ej.bluetooth.BluetoothAdapter;
import ej.bluetooth.BluetoothDevice;
import ej.bluetooth.BluetoothService;
import ej.bluetooth.callbacks.AdvertisementCallbacks;
import ej.bluetooth.callbacks.ConnectionCallbacks;
import ej.bluetooth.util.BluetoothPayloadBuilder;
import ej.bluetooth.util.BluetoothPayloadUtil;
import ej.bluetooth.util.server.BasicServerCharacteristic;
import ej.bluetooth.util.server.ServerStorage;

public class BasicBluetoothServer
implements ConnectionCallbacks,
AdvertisementCallbacks {
    private final BluetoothAdapter adapter;
    private final BluetoothPayloadBuilder bluetoothPayloadBuilder;
    private AdvertisementCallbacks advertisment;
    private ConnectionCallbacks connectionCallbacks;
    private int advertisingThreshold = 1;

    public BasicBluetoothServer(@NonNull BluetoothAdapter adapter, @NonNull BluetoothPayloadBuilder bluetoothPayloadBuilder) {
        this.adapter = adapter;
        this.bluetoothPayloadBuilder = bluetoothPayloadBuilder;
    }

    public BasicBluetoothServer(@NonNull BluetoothAdapter adapter, @NonNull String localName) {
        this(adapter, new BluetoothPayloadBuilder(9, localName));
    }

    public BasicBluetoothServer(@NonNull String localName) {
        this(BluetoothAdapter.getDefaultAdapter(), localName);
    }

    public void start() {
        this.startAdvertising();
    }

    public void startAdvertising() {
        byte[] payload = this.bluetoothPayloadBuilder.getPayload();
        if (BluetoothPayloadUtil.getByte((byte)1, payload) == null) {
            this.bluetoothPayloadBuilder.append((byte)1, (byte)6);
            payload = this.bluetoothPayloadBuilder.getPayload();
        }
        this.adapter.startAdvertising((AdvertisementCallbacks)this, (ConnectionCallbacks)this, payload);
    }

    public void start(@Nullable AdvertisementCallbacks advertisment, @Nullable ConnectionCallbacks connectionCallbacks) {
        this.advertisment = advertisment;
        this.connectionCallbacks = connectionCallbacks;
        this.start();
    }

    public void stop() {
        this.stopAdvertising();
    }

    public void stopAdvertising() {
        this.adapter.stopAdvertising();
    }

    public void onConnectFailed(BluetoothDevice device) {
        if (this.connectionCallbacks != null) {
            this.connectionCallbacks.onConnectFailed(device);
        }
    }

    public void onConnected(BluetoothDevice device) {
        device.discoverServices();
        if (this.connectionCallbacks != null) {
            this.connectionCallbacks.onConnected(device);
        }
        BluetoothDevice[] devices = this.getDevices();
        if (this.advertisingThreshold >= 0 && devices.length >= this.advertisingThreshold) {
            this.stopAdvertising();
        }
    }

    public void onDisconnected(BluetoothDevice device) {
        if (this.connectionCallbacks != null) {
            this.connectionCallbacks.onDisconnected(device);
        }
        ServerStorage.remove(device);
        BluetoothDevice[] devices = this.getDevices();
        if (this.advertisingThreshold >= 0 && devices.length < this.advertisingThreshold) {
            this.startAdvertising();
        }
    }

    public void onPairRequest(BluetoothDevice device) {
        device.pairReply(true);
        if (this.connectionCallbacks != null) {
            this.connectionCallbacks.onPairRequest(device);
        }
    }

    public void onPairCompleted(BluetoothDevice device, boolean success) {
        if (this.connectionCallbacks != null) {
            this.connectionCallbacks.onPairCompleted(device, success);
        }
    }

    public void onPasskeyRequest(BluetoothDevice device) {
        if (this.connectionCallbacks != null) {
            this.connectionCallbacks.onPasskeyRequest(device);
        }
    }

    public void onPasskeyGenerated(BluetoothDevice device, int passkey) {
        if (this.connectionCallbacks != null) {
            this.connectionCallbacks.onPasskeyGenerated(device, passkey);
        }
    }

    public void onServicesDiscovered(BluetoothDevice device) {
        if (this.connectionCallbacks != null) {
            this.connectionCallbacks.onServicesDiscovered(device);
        }
    }

    public BluetoothDevice[] getDevices() {
        return this.adapter.getConnectedDevices();
    }

    public void notifyDevices(BasicServerCharacteristic characteristic) {
        characteristic.notify(this.getDevices());
    }

    public void onAdvertisementCompleted(BluetoothAdapter adapter) {
        if (this.advertisment != null) {
            this.advertisment.onAdvertisementCompleted(adapter);
        }
    }

    public void addService(BluetoothService service) {
        this.adapter.addService(service);
    }

    public void setAdvertisingThreshold(int advertisingThreshold) {
        this.advertisingThreshold = advertisingThreshold;
    }

    public int getAdvertisingThreshold() {
        return this.advertisingThreshold;
    }
}

