/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util.monitoring;

import ej.basictool.map.PackedMap;
import ej.kf.Module;

public class MonitoringData {
    private final PackedMap<Module, ExecutionCounter> executionCounterPerModuleMap;
    private final PackedMap<Module, Long> ramUsagePerModuleMap = new PackedMap();
    private final PackedMap<Module, Integer> originalQuotaPerModuleMap;
    private final boolean runGcBeforeCollecting;
    private final long totalMemory;
    private final long maxMemory;

    public MonitoringData(boolean runGcBeforeCollecting) {
        this.executionCounterPerModuleMap = new PackedMap();
        this.originalQuotaPerModuleMap = new PackedMap();
        this.runGcBeforeCollecting = runGcBeforeCollecting;
        if (runGcBeforeCollecting) {
            System.gc();
        }
        this.totalMemory = Runtime.getRuntime().totalMemory();
        this.maxMemory = Runtime.getRuntime().maxMemory();
    }

    public PackedMap<Module, ExecutionCounter> getExecutionCounterPerModuleMap() {
        return this.executionCounterPerModuleMap;
    }

    public PackedMap<Module, Long> getRamUsagePerModuleMap() {
        return this.ramUsagePerModuleMap;
    }

    public PackedMap<Module, Integer> getOriginalQuotaPerModuleMap() {
        return this.originalQuotaPerModuleMap;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public long getFreeMemory() {
        if (this.runGcBeforeCollecting) {
            System.gc();
        }
        return Runtime.getRuntime().freeMemory();
    }

    public static class ExecutionCounter {
        private long current;
        private long last;

        public ExecutionCounter(long execCounter, long lastExecCounter) {
            this.current = execCounter;
            this.last = lastExecCounter;
        }

        public long getCurrent() {
            return this.current;
        }

        public void setCurrent(long current) {
            this.current = current;
        }

        public long getLast() {
            return this.last;
        }

        public void setLast(long last) {
            this.last = last;
        }
    }
}

