/*
 * Decompiled with CFR 0.152.
 */
package ej.observable;

import ej.basictool.ArrayTools;
import ej.observable.Observer;

public class Observable {
    private Observer[] observers = new Observer[0];
    private boolean changed;

    public void addObserver(Observer observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        Object[] observers = this.observers;
        if (!ArrayTools.contains((Object[])observers, (Object)observer)) {
            this.observers = (Observer[])ArrayTools.add((Object[])observers, (Object)observer);
        }
    }

    public void deleteObserver(Observer observer) {
        this.observers = (Observer[])ArrayTools.remove((Object[])this.observers, (Object)observer);
    }

    public void deleteObservers() {
        this.observers = new Observer[0];
    }

    protected void setChanged() {
        this.changed = true;
    }

    protected void clearChanged() {
        this.changed = false;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public int countObservers() {
        return this.observers.length;
    }

    public void notifyObservers() {
        Observer[] observers;
        if (!this.changed) {
            return;
        }
        this.clearChanged();
        Observer[] observerArray = observers = this.observers;
        int n = observers.length;
        int n2 = 0;
        while (n2 < n) {
            Observer observer = observerArray[n2];
            observer.update();
            ++n2;
        }
    }

    public Observer[] getObservers() {
        return (Observer[])this.observers.clone();
    }
}

