/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt;

import com.is2t.tools.ArrayTools;
import ej.annotation.NonNull;
import ej.annotation.Nullable;
import ej.microui.display.Display;
import ej.microui.display.Displayable;
import ej.microui.display.GraphicsContext;
import ej.microui.util.EventHandler;
import ej.mwt.DesktopEventManagementPolicy;
import ej.mwt.Dialog;
import ej.mwt.Panel;
import ej.mwt.Renderable;
import ej.mwt.RenderableHelper;
import ej.mwt.RepaintRenderable;

public class Desktop
extends Displayable
implements Renderable {
    private boolean isValidating = false;
    @NonNull
    private Panel[] panels;
    @NonNull
    private Dialog[] dialogsStack;
    @Nullable
    private Renderable renderableFrom;
    @NonNull
    private final EventHandler eventManagementPolicy = new DesktopEventManagementPolicy(this);
    @Nullable
    private EventHandler eventHandler;

    public Desktop() {
        this(Display.getDefaultDisplay());
    }

    public Desktop(@NonNull Display display) throws NullPointerException {
        super(display);
        this.panels = new Panel[0];
        this.dialogsStack = new Dialog[0];
    }

    @Override
    public int getX() {
        return 0;
    }

    @Override
    public int getY() {
        return 0;
    }

    @Override
    public int getWidth() {
        return this.getDisplay().getWidth();
    }

    @Override
    public int getHeight() {
        return this.getDisplay().getHeight();
    }

    @Override
    public void repaint(int x, int y, int width, int height) {
        if (this.isShown()) {
            this.getDisplay().callSerially((Runnable)new RepaintRenderable(this, x, y, width, height){

                @Override
                protected void paint(GraphicsContext g) {
                    Desktop.this.paint(g, this.x, this.y, this.width, this.height);
                }
            });
        }
    }

    @Override
    public void render(@NonNull GraphicsContext g) {
    }

    @Nullable
    public Panel getActivePanel() {
        Panel[] panels = this.panels;
        return panels.length == 0 ? null : panels[panels.length - 1];
    }

    public void setActivePanel(@NonNull Panel panel) throws NullPointerException, IllegalArgumentException {
        if (!this.setActivePanelInternal(panel)) {
            throw new IllegalArgumentException();
        }
    }

    boolean setActivePanelInternal(@Nullable Panel panel) {
        if (this.dialogsStack.length != 0) {
            return this.contains(panel);
        }
        Panel[] panels = this.panels;
        int panelsLength = panels.length;
        if (panelsLength != 0) {
            Panel previousActivePanel = panels[panelsLength - 1];
            if (previousActivePanel == panel) {
                return true;
            }
            int i = panelsLength;
            while (--i >= 0) {
                Panel panelCandidate = panels[i];
                if (panelCandidate != panel) continue;
                if (i != panelsLength - 1) {
                    System.arraycopy(panels, i + 1, panels, i, panelsLength - i - 1);
                    panels[panelsLength - 1] = panel;
                    previousActivePanel.becameInactive();
                    panel.becameActive();
                    panel.repaint();
                }
                return true;
            }
        }
        return false;
    }

    @NonNull
    public Panel[] getPanels() {
        return (Panel[])ArrayTools.copy((Object[])this.panels, Panel[].class);
    }

    public void revalidate() {
        if (this.isShown()) {
            this.getDisplay().callSerially(new Runnable(){

                @Override
                public void run() {
                    Desktop.this.validate();
                }
            });
            this.repaint();
        }
    }

    public void validate() {
        int length;
        this.isValidating = true;
        Panel[] panels = this.panels;
        int i = length = panels.length;
        while (--i >= 0) {
            Panel panel = panels[i];
            panel.validate();
        }
        this.isValidating = false;
    }

    @Override
    public void showNotify() {
        Panel[] panelArray = this.panels;
        int n = this.panels.length;
        int n2 = 0;
        while (n2 < n) {
            Panel panel = panelArray[n2];
            panel.showNotify();
            ++n2;
        }
        this.revalidate();
    }

    @Override
    public void hideNotify() {
        Panel[] panelArray = this.panels;
        int n = this.panels.length;
        int n2 = 0;
        while (n2 < n) {
            Panel panel = panelArray[n2];
            panel.hideNotify();
            ++n2;
        }
    }

    public void becomeCurrent() {
        this.showNotify();
    }

    @NonNull
    public EventHandler getController() {
        return this.eventManagementPolicy;
    }

    @Override
    public void setEventHandler(@Nullable EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    @Override
    @Nullable
    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    @Override
    public boolean handleEvent(int event) {
        return RenderableHelper.handleEvent(event, this.eventHandler);
    }

    void repaintFrom(final @NonNull Renderable renderable, int x, int y, int width, int height) {
        if (this.isShown()) {
            this.getDisplay().callSerially((Runnable)new RepaintRenderable(this, x, y, width, height){

                @Override
                protected void paint(GraphicsContext g) {
                    Desktop.this.renderableFrom = renderable;
                    Desktop.this.paint(g, this.x, this.y, this.width, this.height);
                    Desktop.this.renderableFrom = null;
                }
            });
        }
    }

    public final void paint(GraphicsContext g) {
        this.paint(g, 0, 0, this.getWidth(), this.getHeight());
    }

    void paint(@NonNull GraphicsContext g, int x, int y, int width, int height) {
        this.beforePaint(g, x, y, width, height);
        RenderableHelper.paintRenderable(g, this, this);
        Panel[] panels = this.panels;
        int panelsLength = panels.length;
        int i = -1;
        while (++i < panelsLength) {
            Panel panel = panels[i];
            panel.paint(g, x - panel.x, y - panel.y, width, height);
        }
    }

    void beforePaint(@NonNull GraphicsContext g, int x, int y, int width, int height) {
        g.reset();
        g.setSystemClip(0, 0, this.getWidth(), this.getHeight());
        g.translate(0, 0);
        g.setClipAndUpdateSystemClip(x, y, width, height);
    }

    boolean checkPaintFrom(@NonNull Renderable renderable) {
        if (this.renderableFrom != null) {
            if (this.renderableFrom == renderable) {
                this.renderableFrom = null;
            } else {
                return false;
            }
        }
        return true;
    }

    boolean isValidating() {
        return this.isValidating;
    }

    private boolean contains(@Nullable Panel panel) {
        Panel[] panelArray = this.panels;
        int n = this.panels.length;
        int n2 = 0;
        while (n2 < n) {
            Panel panelCandidate = panelArray[n2];
            if (panelCandidate == panel) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    void addPanel(@NonNull Panel panel) {
        Object[] panels = this.panels;
        int panelsLength = panels.length;
        Object previousActivePanel = panelsLength != 0 ? panels[panels.length - 1] : null;
        panels = (Panel[])ArrayTools.add((Object[])panels, (Object)panel);
        Dialog[] dialogsStack = this.dialogsStack;
        int dialogsStackLength = dialogsStack.length;
        if (dialogsStackLength != 0) {
            System.arraycopy(panels, panelsLength - dialogsStackLength, panels, panelsLength - dialogsStackLength + 1, dialogsStackLength);
            panels[panelsLength - dialogsStackLength] = panel;
        }
        this.panels = panels;
        if (this.isShown()) {
            panel.showNotify();
        }
        if (dialogsStackLength == 0) {
            if (previousActivePanel != null) {
                ((Panel)previousActivePanel).becameInactive();
            }
            panel.becameActive();
        }
    }

    void addDialog(@NonNull Dialog dialog) {
        Object[] panels = this.panels;
        int panelsLength = panels.length;
        if (panelsLength != 0) {
            Object previousActivePanel = panels[panelsLength - 1];
            ((Panel)previousActivePanel).becameInactive();
        }
        this.panels = (Panel[])ArrayTools.add((Object[])panels, (Object)dialog);
        this.dialogsStack = (Dialog[])ArrayTools.add((Object[])this.dialogsStack, (Object)dialog);
        if (this.isShown()) {
            dialog.showNotify();
        }
        dialog.becameActive();
    }

    void removePanel(@NonNull Panel panel) {
        Object[] panels = this.panels;
        int panelsLength = panels.length;
        boolean wasActive = panelsLength == 0 ? false : panels[panelsLength - 1] == panel;
        this.panels = (Panel[])ArrayTools.remove((Object[])panels, (Object)panel);
        if (wasActive) {
            panel.becameInactive();
        }
        if (this.isShown()) {
            panel.hideNotify();
        }
        if (wasActive && panelsLength > 1) {
            this.panels[panelsLength - 2].becameActive();
        }
    }

    void removeDialog(@NonNull Dialog dialog) {
        this.removePanel(dialog);
        this.dialogsStack = (Dialog[])ArrayTools.remove((Object[])this.dialogsStack, (Object)dialog);
    }

    @Nullable
    public Panel panelAt(int x, int y) {
        int length;
        Panel[] panels = this.panels;
        int i = length = panels.length;
        while (--i >= 0) {
            Panel panel = panels[i];
            if (!panel.contains(x, y)) continue;
            return panel;
        }
        return null;
    }

    public boolean isAccessible(@NonNull Panel panel) {
        Dialog[] dialogsStack = this.dialogsStack;
        int dialogsStackLength = dialogsStack.length;
        return dialogsStackLength == 0 || panel == dialogsStack[dialogsStackLength - 1];
    }
}

