/*
 * Decompiled with CFR 0.152.
 */
package ej.microui.display;

import ej.drawing.LLDWPainter;
import ej.microui.display.LLUIDisplay;
import ej.microui.display.MicroUIGraphicsContext;
import ej.microui.display.MicroUIImage;
import ej.microui.display.MicroUIImageFormat;

public interface UIDrawing {
    public MicroUIImageFormat handledFormat();

    default public void writePixel(MicroUIGraphicsContext gc, int x, int y) {
        gc.reportError(1);
    }

    default public void drawLine(MicroUIGraphicsContext gc, int x1, int y1, int x2, int y2) {
        gc.reportError(1);
    }

    default public void drawHorizontalLine(MicroUIGraphicsContext gc, int x1, int x2, int y) {
        gc.reportError(1);
    }

    default public void drawVerticalLine(MicroUIGraphicsContext gc, int x, int y1, int y2) {
        gc.reportError(1);
    }

    default public void drawRectangle(MicroUIGraphicsContext gc, int x1, int y1, int x2, int y2) {
        gc.reportError(1);
    }

    default public void fillRectangle(MicroUIGraphicsContext gc, int x1, int y1, int x2, int y2) {
        gc.reportError(1);
    }

    default public void drawRoundedRectangle(MicroUIGraphicsContext gc, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        gc.reportError(1);
    }

    default public void fillRoundedRectangle(MicroUIGraphicsContext gc, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        gc.reportError(1);
    }

    default public void drawCircleArc(MicroUIGraphicsContext gc, int x, int y, int diameter, float startAngle, float arcAngle) {
        gc.reportError(1);
    }

    default public void drawEllipseArc(MicroUIGraphicsContext gc, int x, int y, int width, int height, float startAngle, float arcAngle) {
        gc.reportError(1);
    }

    default public void fillCircleArc(MicroUIGraphicsContext gc, int x, int y, int diameter, float startAngle, float arcAngle) {
        gc.reportError(1);
    }

    default public void fillEllipseArc(MicroUIGraphicsContext gc, int x, int y, int width, int height, float startAngle, float arcAngle) {
        gc.reportError(1);
    }

    default public void drawEllipse(MicroUIGraphicsContext gc, int x, int y, int width, int height) {
        gc.reportError(1);
    }

    default public void fillEllipse(MicroUIGraphicsContext gc, int x, int y, int width, int height) {
        gc.reportError(1);
    }

    default public void drawCircle(MicroUIGraphicsContext gc, int x, int y, int diameter) {
        gc.reportError(1);
    }

    default public void fillCircle(MicroUIGraphicsContext gc, int x, int y, int diameter) {
        gc.reportError(1);
    }

    default public void drawImage(MicroUIGraphicsContext gc, MicroUIImage img, int regionX, int regionY, int width, int height, int x, int y, int alpha) {
        LLUIDisplay.Instance.getUIImageDrawer(img).draw(gc, img, regionX, regionY, width, height, x, y, alpha);
    }

    default public void drawThickFadedPoint(MicroUIGraphicsContext gc, int x, int y, int thickness, int fade) {
        gc.reportError(1);
    }

    default public void drawThickFadedLine(MicroUIGraphicsContext gc, int x1, int y1, int x2, int y2, int thickness, int fade, LLDWPainter.DrawingCap start, LLDWPainter.DrawingCap end) {
        gc.reportError(1);
    }

    default public void drawThickFadedCircle(MicroUIGraphicsContext gc, int x, int y, int diameter, int thickness, int fade) {
        gc.reportError(1);
    }

    default public void drawThickFadedCircleArc(MicroUIGraphicsContext gc, int x, int y, int diameter, float startAngle, float arcAngle, int thickness, int fade, LLDWPainter.DrawingCap start, LLDWPainter.DrawingCap end) {
        gc.reportError(1);
    }

    default public void drawThickFadedEllipse(MicroUIGraphicsContext gc, int x, int y, int width, int height, int thickness, int fade) {
        gc.reportError(1);
    }

    default public void drawThickLine(MicroUIGraphicsContext gc, int x1, int y1, int x2, int y2, int thickness) {
        gc.reportError(1);
    }

    default public void drawThickCircle(MicroUIGraphicsContext gc, int x, int y, int diameter, int thickness) {
        gc.reportError(1);
    }

    default public void drawThickEllipse(MicroUIGraphicsContext gc, int x, int y, int width, int height, int thickness) {
        gc.reportError(1);
    }

    default public void drawThickCircleArc(MicroUIGraphicsContext gc, int x, int y, int diameter, float startAngle, float arcAngle, int thickness) {
        gc.reportError(1);
    }

    default public void drawFlippedImage(MicroUIGraphicsContext gc, MicroUIImage img, int regionX, int regionY, int width, int height, int x, int y, LLDWPainter.DrawingFlip flip, int alpha) {
        LLUIDisplay.Instance.getUIImageDrawer(img).drawFlipped(gc, img, regionX, regionY, width, height, x, y, flip, alpha);
    }

    default public void drawRotatedImageNearestNeighbor(MicroUIGraphicsContext gc, MicroUIImage img, int x, int y, int rotationX, int rotationY, float angle, int alpha) {
        LLUIDisplay.Instance.getUIImageDrawer(img).drawRotatedNearestNeighbor(gc, img, x, y, rotationX, rotationY, angle, alpha);
    }

    default public void drawRotatedImageBilinear(MicroUIGraphicsContext gc, MicroUIImage img, int x, int y, int rotationX, int rotationY, float angle, int alpha) {
        LLUIDisplay.Instance.getUIImageDrawer(img).drawRotatedBilinear(gc, img, x, y, rotationX, rotationY, angle, alpha);
    }

    default public void drawScaledImageNearestNeighbor(MicroUIGraphicsContext gc, MicroUIImage img, int x, int y, float factorX, float factorY, int alpha) {
        LLUIDisplay.Instance.getUIImageDrawer(img).drawScaledNearestNeighbor(gc, img, x, y, factorX, factorY, alpha);
    }

    default public void drawScaledImageBilinear(MicroUIGraphicsContext gc, MicroUIImage img, int x, int y, float factorX, float factorY, int alpha) {
        LLUIDisplay.Instance.getUIImageDrawer(img).drawScaledBilinear(gc, img, x, y, factorX, factorY, alpha);
    }
}

