/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.tcp;

import ej.hoka.log.Messages;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public abstract class TCPServer {
    private Thread thread;
    private ServerSocket serverSocket;

    public TCPServer(ServerSocket connection) {
        this.serverSocket = connection;
    }

    protected abstract void addConnection(Socket var1);

    protected ServerSocket getCurrentConnection() {
        return this.serverSocket;
    }

    protected String getName() {
        return TCPServer.class.getSimpleName();
    }

    public boolean isStopped() {
        return this.serverSocket == null || this.thread == null;
    }

    private Thread newProcess() {
        return new Thread(this.getName()){

            @Override
            public void run() {
                ServerSocket serverSocket = TCPServer.this.getCurrentConnection();
                if (serverSocket == null) {
                    return;
                }
                while (true) {
                    Socket connector;
                    try {
                        connector = serverSocket.accept();
                    }
                    catch (IOException e) {
                        if (TCPServer.this.getCurrentConnection() == null) {
                            return;
                        }
                        Messages.LOGGER.log('S', "Hoka", -255, (Throwable)e);
                        continue;
                    }
                    TCPServer.this.addConnection(connector);
                }
            }
        };
    }

    public void start() {
        if (this.thread != null) {
            throw new IllegalStateException(Messages.BUILDER.buildMessage('S', "Hoka", -2));
        }
        this.thread = this.newProcess();
        this.thread.start();
    }

    public void stop() {
        try {
            ServerSocket serverSocket = this.serverSocket;
            this.serverSocket = null;
            try {
                serverSocket.close();
            }
            catch (Throwable throwable) {
                this.thread = null;
                return;
            }
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        finally {
            this.thread = null;
        }
    }
}

