/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http.support;

import java.util.HashMap;
import java.util.Map;

public class MIMEUtils {
    private static final String GIF = "gif";
    private static final String JPEG = "jpeg";
    private static final String XML = "xml";
    private static final String HTML = "html";
    private static final String PNG = "png";
    private static final String CSS = "css";
    private static final String IMAGE = "image/";
    private static final String TEXT = "text/";
    private static final String APPLICATION = "application/";
    public static final String MIME_PLAINTEXT = "text/plain";
    public static final String MIME_HTML = "text/html";
    public static final String MIME_XML = "text/xml";
    public static final String MIME_DEFAULT_BINARY = "application/octet-stream";
    public static final String MIME_CSS = "text/css";
    public static final String MIME_PNG = "image/png";
    public static final String MIME_JPEG = "image/jpeg";
    public static final String MIME_GIF = "image/gif";
    public static final String MIME_JS = "application/x-javascript";
    public static final String MIME_FORM_ENCODED_DATA = "application/x-www-form-urlencoded";
    public static final String MIME_MULTIPART_FORM_ENCODED_DATA = "multipart/form-data";
    private static final Map<String, String> FILE_EXTENSION_TO_MIME_TYPE = new HashMap<String, String>();

    static {
        MIMEUtils.mapFileExtensionToMIMEType(".png", MIME_PNG);
        MIMEUtils.mapFileExtensionToMIMEType(".css", MIME_CSS);
        MIMEUtils.mapFileExtensionToMIMEType(".gif", MIME_GIF);
        MIMEUtils.mapFileExtensionToMIMEType(".jpeg", MIME_JPEG);
        MIMEUtils.mapFileExtensionToMIMEType(".jpg", MIME_JPEG);
        MIMEUtils.mapFileExtensionToMIMEType(".html", MIME_HTML);
        MIMEUtils.mapFileExtensionToMIMEType(".htm", MIME_HTML);
        MIMEUtils.mapFileExtensionToMIMEType(".js", MIME_JS);
        MIMEUtils.mapFileExtensionToMIMEType(".txt", MIME_PLAINTEXT);
        MIMEUtils.mapFileExtensionToMIMEType(".xml", MIME_XML);
    }

    private MIMEUtils() {
    }

    public static String getMIMEType(String uri) {
        int pos;
        if (uri == null || (pos = uri.lastIndexOf(46)) == -1) {
            return null;
        }
        return FILE_EXTENSION_TO_MIME_TYPE.get(uri.substring(pos));
    }

    public static boolean mapFileExtensionToMIMEType(String fileExtension, String mimeType) {
        if (fileExtension == null || mimeType == null) {
            throw new NullPointerException();
        }
        if (fileExtension.charAt(0) != '.') {
            fileExtension = String.valueOf('.') + fileExtension;
        }
        if (FILE_EXTENSION_TO_MIME_TYPE.get(fileExtension) == null) {
            FILE_EXTENSION_TO_MIME_TYPE.put(fileExtension, mimeType);
            return true;
        }
        return false;
    }
}

