/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.util.color;

import ej.bon.XMath;

public class ColorHelper {
    private static final int MAX_COLOR_COMPONENT_VALUE = 255;
    private static final int RED_SHIFT = 16;
    private static final int GREEN_SHIFT = 8;
    private static final int BLUE_SHIFT = 0;
    private static final int RED_MASK = 0xFF0000;
    private static final int GREEN_MASK = 65280;
    private static final int BLUE_MASK = 255;

    private ColorHelper() {
    }

    public static int getRed(int color) {
        return (color & 0xFF0000) >>> 16;
    }

    public static int getGreen(int color) {
        return (color & 0xFF00) >>> 8;
    }

    public static int getBlue(int color) {
        return (color & 0xFF) >>> 0;
    }

    public static int getColor(int red, int green, int blue) {
        return red << 16 & 0xFF0000 | green << 8 & 0xFF00 | blue << 0 & 0xFF;
    }

    public static int updateComponent(int component, int increment) {
        return XMath.limit((int)(component + increment), (int)0, (int)255);
    }
}

