/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg.image;

import ej.microvg.image.LinearGradient;
import ej.microvg.image.Path;
import java.awt.Color;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public interface ImageGenerator {
    public int encodeCommand(Command var1);

    public int encodeColor(Color var1, float var2);

    public byte[] encodeGradient(LinearGradient var1);

    public byte[] encodePath(Path var1);

    default public ByteBuffer newByteBuffer(int size) {
        return ByteBuffer.allocate(size).order(ByteOrder.LITTLE_ENDIAN);
    }

    public static enum Command {
        COMMAND_CLOSE,
        COMMAND_MOVE,
        COMMAND_MOVE_REL,
        COMMAND_LINE,
        COMMAND_LINE_REL,
        COMMAND_QUAD,
        COMMAND_QUAD_REL,
        COMMAND_CUBIC,
        COMMAND_CUBIC_REL;

    }

    public static enum FillRule {
        FILLRULE_NOZERO,
        FILLRULE_EVENODD;


        public byte toByte() {
            switch (this) {
                case FILLRULE_NOZERO: {
                    return 0;
                }
                case FILLRULE_EVENODD: {
                    return 1;
                }
            }
            return -1;
        }
    }

    public static enum Format {
        VG_S8(1),
        VG_S16(2),
        VG_S32(4),
        VG_FP32(4);

        private final int unitSize;

        private Format(int unitSize) {
            this.unitSize = unitSize;
        }

        public int getUnitSize() {
            return this.unitSize;
        }
    }
}

