/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.log;

import ej.hoka.http.Config;
import ej.hoka.log.Logger;

class SimpleLogger
implements Logger {
    private static final int NONE = 0;
    private static final int TRACE = 69905;
    private static final int DEBUG = 4369;
    private static final int INFO = 273;
    private static final int WARN = 17;
    private static final int ERROR = 1;
    private static final String TRACE_PREFIX = "[TRACE]\t";
    private static final String DEBUG_PREFIX = "[DEBUG]\t";
    private static final String INFO_PREFIX = "[INFO]\t";
    private static final String WARN_PREFIX = "[WARN]\t";
    private static final String ERROR_PREFIX = "[ERROR]\t";
    private final int level;

    SimpleLogger() {
        block23: {
            String slevel;
            block22: {
                slevel = Config.getInstance().getLoggerLevel();
                if (!slevel.trim().isEmpty()) break block22;
                this.level = 273;
                break block23;
            }
            switch (slevel.trim().toLowerCase()) {
                case "none": {
                    this.level = 0;
                    break;
                }
                case "trace": {
                    this.level = 69905;
                    break;
                }
                case "debug": {
                    this.level = 4369;
                    break;
                }
                case "info": {
                    this.level = 273;
                    break;
                }
                case "warn": {
                    this.level = 17;
                    break;
                }
                case "error": {
                    this.level = 1;
                    break;
                }
                default: {
                    this.level = 273;
                }
            }
        }
    }

    @Override
    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            System.out.println(TRACE_PREFIX + msg);
        }
    }

    @Override
    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            System.out.println(DEBUG_PREFIX + msg);
        }
    }

    @Override
    public void info(String msg) {
        if (this.isInfoEnabled()) {
            System.out.println(INFO_PREFIX + msg);
        }
    }

    @Override
    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            System.out.println(WARN_PREFIX + msg);
        }
    }

    @Override
    public void error(String msg) {
        if (this.isErrorEnabled()) {
            System.out.println(ERROR_PREFIX + msg);
        }
    }

    @Override
    public void error(String msg, Throwable e) {
        if (this.isErrorEnabled()) {
            System.out.println(ERROR_PREFIX + msg);
            e.printStackTrace();
        }
    }

    @Override
    public void error(Throwable e) {
        if (this.isErrorEnabled()) {
            System.out.println(ERROR_PREFIX + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return (0x11111 & this.level) == 69905;
    }

    @Override
    public boolean isDebugEnabled() {
        return (0x1111 & this.level) == 4369;
    }

    @Override
    public boolean isInfoEnabled() {
        return (0x111 & this.level) == 273;
    }

    @Override
    public boolean isWarnEnabled() {
        return (0x11 & this.level) == 17;
    }

    @Override
    public boolean isErrorEnabled() {
        return (1 & this.level) == 1;
    }
}

