/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import ej.annotation.Nullable;
import java.math.IntegerHelper;
import java.math.MutableBigInteger;
import java.util.Arrays;
import java.util.Random;

public class BigInteger
extends Number
implements Comparable<BigInteger> {
    final int signum;
    final int[] mag;
    @Deprecated
    private int bitCount;
    @Deprecated
    private int bitLength;
    @Deprecated
    private int lowestSetBit;
    @Deprecated
    private int firstNonzeroIntNum;
    static final long LONG_MASK = 0xFFFFFFFFL;
    private static final int MAX_MAG_LENGTH = 0x4000000;
    private static final int KARATSUBA_THRESHOLD = 80;
    private static final int TOOM_COOK_THRESHOLD = 240;
    private static final int KARATSUBA_SQUARE_THRESHOLD = 128;
    private static final int TOOM_COOK_SQUARE_THRESHOLD = 216;
    static final int BURNIKEL_ZIEGLER_THRESHOLD = 80;
    static final int BURNIKEL_ZIEGLER_OFFSET = 40;
    private static final int SCHOENHAGE_BASE_CONVERSION_THRESHOLD = 20;
    private static final int MULTIPLY_SQUARE_THRESHOLD = 20;
    private static long[] bitsPerDigit;
    private static final int MAX_CONSTANT = 16;
    private static BigInteger[] posConst;
    private static BigInteger[] negConst;
    private static volatile BigInteger[][] powerCache;
    private static final double[] logCache;
    private static final double LOG_TWO;
    public static final BigInteger ZERO;
    public static final BigInteger ONE;
    private static final BigInteger NEGATIVE_ONE;
    public static final BigInteger TEN;
    static int[] bnExpModThreshTable;
    private static String[] zeros;
    private static int[] digitsPerLong;
    private static BigInteger[] longRadix;
    private static int[] digitsPerInt;
    private static int[] intRadix;
    private static final long serialVersionUID = -8287574255936472291L;

    static {
        long[] lArray = new long[37];
        lArray[2] = 1024L;
        lArray[3] = 1624L;
        lArray[4] = 2048L;
        lArray[5] = 2378L;
        lArray[6] = 2648L;
        lArray[7] = 2875L;
        lArray[8] = 3072L;
        lArray[9] = 3247L;
        lArray[10] = 3402L;
        lArray[11] = 3543L;
        lArray[12] = 3672L;
        lArray[13] = 3790L;
        lArray[14] = 3899L;
        lArray[15] = 4001L;
        lArray[16] = 4096L;
        lArray[17] = 4186L;
        lArray[18] = 4271L;
        lArray[19] = 4350L;
        lArray[20] = 4426L;
        lArray[21] = 4498L;
        lArray[22] = 4567L;
        lArray[23] = 4633L;
        lArray[24] = 4696L;
        lArray[25] = 4756L;
        lArray[26] = 4814L;
        lArray[27] = 4870L;
        lArray[28] = 4923L;
        lArray[29] = 4975L;
        lArray[30] = 5025L;
        lArray[31] = 5074L;
        lArray[32] = 5120L;
        lArray[33] = 5166L;
        lArray[34] = 5210L;
        lArray[35] = 5253L;
        lArray[36] = 5295L;
        bitsPerDigit = lArray;
        posConst = new BigInteger[17];
        negConst = new BigInteger[17];
        LOG_TWO = Math.log(2.0);
        int i = 1;
        while (i <= 16) {
            int[] magnitude = new int[]{i};
            BigInteger.posConst[i] = new BigInteger(magnitude, 1);
            BigInteger.negConst[i] = new BigInteger(magnitude, -1);
            ++i;
        }
        powerCache = new BigInteger[37][];
        logCache = new double[37];
        i = 2;
        while (i <= 36) {
            BigInteger.powerCache[i] = new BigInteger[]{BigInteger.valueOf(i)};
            BigInteger.logCache[i] = Math.log(i);
            ++i;
        }
        ZERO = new BigInteger(new int[0], 0);
        ONE = BigInteger.valueOf(1L);
        NEGATIVE_ONE = BigInteger.valueOf(-1L);
        TEN = BigInteger.valueOf(10L);
        bnExpModThreshTable = new int[]{7, 25, 81, 241, 673, 1793, Integer.MAX_VALUE};
        zeros = new String[64];
        BigInteger.zeros[63] = "000000000000000000000000000000000000000000000000000000000000000";
        i = 0;
        while (i < 63) {
            BigInteger.zeros[i] = zeros[63].substring(0, i);
            ++i;
        }
        int[] nArray = new int[37];
        nArray[2] = 62;
        nArray[3] = 39;
        nArray[4] = 31;
        nArray[5] = 27;
        nArray[6] = 24;
        nArray[7] = 22;
        nArray[8] = 20;
        nArray[9] = 19;
        nArray[10] = 18;
        nArray[11] = 18;
        nArray[12] = 17;
        nArray[13] = 17;
        nArray[14] = 16;
        nArray[15] = 16;
        nArray[16] = 15;
        nArray[17] = 15;
        nArray[18] = 15;
        nArray[19] = 14;
        nArray[20] = 14;
        nArray[21] = 14;
        nArray[22] = 14;
        nArray[23] = 13;
        nArray[24] = 13;
        nArray[25] = 13;
        nArray[26] = 13;
        nArray[27] = 13;
        nArray[28] = 13;
        nArray[29] = 12;
        nArray[30] = 12;
        nArray[31] = 12;
        nArray[32] = 12;
        nArray[33] = 12;
        nArray[34] = 12;
        nArray[35] = 12;
        nArray[36] = 12;
        digitsPerLong = nArray;
        BigInteger[] bigIntegerArray = new BigInteger[37];
        bigIntegerArray[2] = BigInteger.valueOf(0x4000000000000000L);
        bigIntegerArray[3] = BigInteger.valueOf(4052555153018976267L);
        bigIntegerArray[4] = BigInteger.valueOf(0x4000000000000000L);
        bigIntegerArray[5] = BigInteger.valueOf(7450580596923828125L);
        bigIntegerArray[6] = BigInteger.valueOf(4738381338321616896L);
        bigIntegerArray[7] = BigInteger.valueOf(3909821048582988049L);
        bigIntegerArray[8] = BigInteger.valueOf(0x1000000000000000L);
        bigIntegerArray[9] = BigInteger.valueOf(1350851717672992089L);
        bigIntegerArray[10] = BigInteger.valueOf(1000000000000000000L);
        bigIntegerArray[11] = BigInteger.valueOf(5559917313492231481L);
        bigIntegerArray[12] = BigInteger.valueOf(2218611106740436992L);
        bigIntegerArray[13] = BigInteger.valueOf(8650415919381337933L);
        bigIntegerArray[14] = BigInteger.valueOf(2177953337809371136L);
        bigIntegerArray[15] = BigInteger.valueOf(6568408355712890625L);
        bigIntegerArray[16] = BigInteger.valueOf(0x1000000000000000L);
        bigIntegerArray[17] = BigInteger.valueOf(2862423051509815793L);
        bigIntegerArray[18] = BigInteger.valueOf(6746640616477458432L);
        bigIntegerArray[19] = BigInteger.valueOf(799006685782884121L);
        bigIntegerArray[20] = BigInteger.valueOf(1638400000000000000L);
        bigIntegerArray[21] = BigInteger.valueOf(3243919932521508681L);
        bigIntegerArray[22] = BigInteger.valueOf(6221821273427820544L);
        bigIntegerArray[23] = BigInteger.valueOf(504036361936467383L);
        bigIntegerArray[24] = BigInteger.valueOf(876488338465357824L);
        bigIntegerArray[25] = BigInteger.valueOf(1490116119384765625L);
        bigIntegerArray[26] = BigInteger.valueOf(2481152873203736576L);
        bigIntegerArray[27] = BigInteger.valueOf(4052555153018976267L);
        bigIntegerArray[28] = BigInteger.valueOf(6502111422497947648L);
        bigIntegerArray[29] = BigInteger.valueOf(353814783205469041L);
        bigIntegerArray[30] = BigInteger.valueOf(531441000000000000L);
        bigIntegerArray[31] = BigInteger.valueOf(787662783788549761L);
        bigIntegerArray[32] = BigInteger.valueOf(0x1000000000000000L);
        bigIntegerArray[33] = BigInteger.valueOf(1667889514952984961L);
        bigIntegerArray[34] = BigInteger.valueOf(2386420683693101056L);
        bigIntegerArray[35] = BigInteger.valueOf(3379220508056640625L);
        bigIntegerArray[36] = BigInteger.valueOf(4738381338321616896L);
        longRadix = bigIntegerArray;
        int[] nArray2 = new int[37];
        nArray2[2] = 30;
        nArray2[3] = 19;
        nArray2[4] = 15;
        nArray2[5] = 13;
        nArray2[6] = 11;
        nArray2[7] = 11;
        nArray2[8] = 10;
        nArray2[9] = 9;
        nArray2[10] = 9;
        nArray2[11] = 8;
        nArray2[12] = 8;
        nArray2[13] = 8;
        nArray2[14] = 8;
        nArray2[15] = 7;
        nArray2[16] = 7;
        nArray2[17] = 7;
        nArray2[18] = 7;
        nArray2[19] = 7;
        nArray2[20] = 7;
        nArray2[21] = 7;
        nArray2[22] = 6;
        nArray2[23] = 6;
        nArray2[24] = 6;
        nArray2[25] = 6;
        nArray2[26] = 6;
        nArray2[27] = 6;
        nArray2[28] = 6;
        nArray2[29] = 6;
        nArray2[30] = 6;
        nArray2[31] = 6;
        nArray2[32] = 6;
        nArray2[33] = 6;
        nArray2[34] = 6;
        nArray2[35] = 6;
        nArray2[36] = 5;
        digitsPerInt = nArray2;
        int[] nArray3 = new int[37];
        nArray3[2] = 0x40000000;
        nArray3[3] = 1162261467;
        nArray3[4] = 0x40000000;
        nArray3[5] = 1220703125;
        nArray3[6] = 362797056;
        nArray3[7] = 1977326743;
        nArray3[8] = 0x40000000;
        nArray3[9] = 387420489;
        nArray3[10] = 1000000000;
        nArray3[11] = 214358881;
        nArray3[12] = 429981696;
        nArray3[13] = 815730721;
        nArray3[14] = 1475789056;
        nArray3[15] = 170859375;
        nArray3[16] = 0x10000000;
        nArray3[17] = 410338673;
        nArray3[18] = 612220032;
        nArray3[19] = 893871739;
        nArray3[20] = 1280000000;
        nArray3[21] = 1801088541;
        nArray3[22] = 113379904;
        nArray3[23] = 148035889;
        nArray3[24] = 191102976;
        nArray3[25] = 244140625;
        nArray3[26] = 308915776;
        nArray3[27] = 387420489;
        nArray3[28] = 481890304;
        nArray3[29] = 594823321;
        nArray3[30] = 729000000;
        nArray3[31] = 887503681;
        nArray3[32] = 0x40000000;
        nArray3[33] = 1291467969;
        nArray3[34] = 1544804416;
        nArray3[35] = 1838265625;
        nArray3[36] = 60466176;
        intRadix = nArray3;
    }

    public BigInteger(byte[] val) {
        if (val.length == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        if (val[0] < 0) {
            this.mag = BigInteger.makePositive(val);
            this.signum = -1;
        } else {
            this.mag = BigInteger.stripLeadingZeroBytes(val);
            int n = this.signum = this.mag.length == 0 ? 0 : 1;
        }
        if (this.mag.length >= 0x4000000) {
            this.checkRange();
        }
    }

    private BigInteger(int[] val) {
        if (val.length == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        if (val[0] < 0) {
            this.mag = BigInteger.makePositive(val);
            this.signum = -1;
        } else {
            this.mag = BigInteger.trustedStripLeadingZeroInts(val);
            int n = this.signum = this.mag.length == 0 ? 0 : 1;
        }
        if (this.mag.length >= 0x4000000) {
            this.checkRange();
        }
    }

    public BigInteger(int signum, byte[] magnitude) {
        this.mag = BigInteger.stripLeadingZeroBytes(magnitude);
        if (signum < -1 || signum > 1) {
            throw new NumberFormatException("Invalid signum value");
        }
        if (this.mag.length == 0) {
            this.signum = 0;
        } else {
            if (signum == 0) {
                throw new NumberFormatException("signum-magnitude mismatch");
            }
            this.signum = signum;
        }
        if (this.mag.length >= 0x4000000) {
            this.checkRange();
        }
    }

    private BigInteger(int signum, int[] magnitude) {
        this.mag = BigInteger.stripLeadingZeroInts(magnitude);
        if (signum < -1 || signum > 1) {
            throw new NumberFormatException("Invalid signum value");
        }
        if (this.mag.length == 0) {
            this.signum = 0;
        } else {
            if (signum == 0) {
                throw new NumberFormatException("signum-magnitude mismatch");
            }
            this.signum = signum;
        }
        if (this.mag.length >= 0x4000000) {
            this.checkRange();
        }
    }

    /*
     * Unable to fully structure code
     */
    public BigInteger(String val, int radix) {
        super();
        cursor = 0;
        len = val.length();
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("Radix out of range");
        }
        if (len == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        sign = 1;
        index1 = val.lastIndexOf(45);
        index2 = val.lastIndexOf(43);
        if (index1 >= 0) {
            if (index1 != 0 || index2 >= 0) {
                throw new NumberFormatException("Illegal embedded sign character");
            }
            sign = -1;
            cursor = 1;
        } else if (index2 >= 0) {
            if (index2 != 0) {
                throw new NumberFormatException("Illegal embedded sign character");
            }
            cursor = 1;
        }
        if (cursor != len) ** GOTO lbl24
        throw new NumberFormatException("Zero length BigInteger");
lbl-1000:
        // 1 sources

        {
            ++cursor;
lbl24:
            // 2 sources

            ** while (cursor < len && Character.digit((char)val.charAt((int)cursor), (int)radix) == 0)
        }
lbl25:
        // 1 sources

        if (cursor == len) {
            this.signum = 0;
            this.mag = BigInteger.ZERO.mag;
            return;
        }
        numDigits = len - cursor;
        this.signum = sign;
        numBits = ((long)numDigits * BigInteger.bitsPerDigit[radix] >>> 10) + 1L;
        if (numBits + 31L >= 0x100000000L) {
            BigInteger.reportOverflow();
        }
        numWords = (int)(numBits + 31L) >>> 5;
        magnitude = new int[numWords];
        firstGroupLen = numDigits % BigInteger.digitsPerInt[radix];
        if (firstGroupLen == 0) {
            firstGroupLen = BigInteger.digitsPerInt[radix];
        }
        group = val.substring(cursor, cursor += firstGroupLen);
        magnitude[numWords - 1] = Integer.parseInt(group, radix);
        if (magnitude[numWords - 1] < 0) {
            throw new NumberFormatException("Illegal digit");
        }
        superRadix = BigInteger.intRadix[radix];
        groupVal = 0;
        while (cursor < len) {
            if ((groupVal = Integer.parseInt(group = val.substring(cursor, cursor += BigInteger.digitsPerInt[radix]), radix)) < 0) {
                throw new NumberFormatException("Illegal digit");
            }
            BigInteger.destructiveMulAdd(magnitude, superRadix, groupVal);
        }
        this.mag = BigInteger.trustedStripLeadingZeroInts(magnitude);
        if (this.mag.length >= 0x4000000) {
            this.checkRange();
        }
    }

    BigInteger(char[] val, int sign, int len) {
        int numWords;
        int cursor = 0;
        while (cursor < len && Character.digit(val[cursor], 10) == 0) {
            ++cursor;
        }
        if (cursor == len) {
            this.signum = 0;
            this.mag = BigInteger.ZERO.mag;
            return;
        }
        int numDigits = len - cursor;
        this.signum = sign;
        if (len < 10) {
            numWords = 1;
        } else {
            long numBits = ((long)numDigits * bitsPerDigit[10] >>> 10) + 1L;
            if (numBits + 31L >= 0x100000000L) {
                BigInteger.reportOverflow();
            }
            numWords = (int)(numBits + 31L) >>> 5;
        }
        int[] magnitude = new int[numWords];
        int firstGroupLen = numDigits % digitsPerInt[10];
        if (firstGroupLen == 0) {
            firstGroupLen = digitsPerInt[10];
        }
        magnitude[numWords - 1] = this.parseInt(val, cursor, cursor += firstGroupLen);
        while (cursor < len) {
            int groupVal = this.parseInt(val, cursor, cursor += digitsPerInt[10]);
            BigInteger.destructiveMulAdd(magnitude, intRadix[10], groupVal);
        }
        this.mag = BigInteger.trustedStripLeadingZeroInts(magnitude);
        if (this.mag.length >= 0x4000000) {
            this.checkRange();
        }
    }

    private int parseInt(char[] source, int start, int end) {
        int result;
        if ((result = Character.digit(source[start++], 10)) == -1) {
            throw new NumberFormatException(new String(source));
        }
        int index = start;
        while (index < end) {
            int nextVal = Character.digit(source[index], 10);
            if (nextVal == -1) {
                throw new NumberFormatException(new String(source));
            }
            result = 10 * result + nextVal;
            ++index;
        }
        return result;
    }

    private static void destructiveMulAdd(int[] x, int y, int z) {
        long ylong = (long)y & 0xFFFFFFFFL;
        long zlong = (long)z & 0xFFFFFFFFL;
        int len = x.length;
        long product = 0L;
        long carry = 0L;
        int i = len - 1;
        while (i >= 0) {
            product = ylong * ((long)x[i] & 0xFFFFFFFFL) + carry;
            x[i] = (int)product;
            carry = product >>> 32;
            --i;
        }
        long sum = ((long)x[len - 1] & 0xFFFFFFFFL) + zlong;
        x[len - 1] = (int)sum;
        carry = sum >>> 32;
        int i2 = len - 2;
        while (i2 >= 0) {
            sum = ((long)x[i2] & 0xFFFFFFFFL) + carry;
            x[i2] = (int)sum;
            carry = sum >>> 32;
            --i2;
        }
    }

    public BigInteger(String val) {
        this(val, 10);
    }

    public BigInteger(int numBits, Random rnd) {
        this(1, BigInteger.randomBits(numBits, rnd));
    }

    private static byte[] randomBits(int numBits, Random rnd) {
        if (numBits < 0) {
            throw new IllegalArgumentException("numBits must be non-negative");
        }
        int numBytes = (int)(((long)numBits + 7L) / 8L);
        byte[] randomBits = new byte[numBytes];
        if (numBytes > 0) {
            rnd.nextBytes(randomBits);
            int excessBits = 8 * numBytes - numBits;
            randomBits[0] = (byte)(randomBits[0] & (1 << 8 - excessBits) - 1);
        }
        return randomBits;
    }

    BigInteger(int[] magnitude, int signum) {
        this.signum = magnitude.length == 0 ? 0 : signum;
        this.mag = magnitude;
        if (this.mag.length >= 0x4000000) {
            this.checkRange();
        }
    }

    private void checkRange() {
        if (this.mag.length > 0x4000000 || this.mag.length == 0x4000000 && this.mag[0] < 0) {
            BigInteger.reportOverflow();
        }
    }

    private static void reportOverflow() {
        throw new ArithmeticException("BigInteger would overflow supported range");
    }

    public static BigInteger valueOf(long val) {
        if (val == 0L) {
            return ZERO;
        }
        if (val > 0L && val <= 16L) {
            return posConst[(int)val];
        }
        if (val < 0L && val >= -16L) {
            return negConst[(int)(-val)];
        }
        return new BigInteger(val);
    }

    private BigInteger(long val) {
        if (val < 0L) {
            val = -val;
            this.signum = -1;
        } else {
            this.signum = 1;
        }
        int highWord = (int)(val >>> 32);
        if (highWord == 0) {
            this.mag = new int[1];
            this.mag[0] = (int)val;
        } else {
            this.mag = new int[2];
            this.mag[0] = highWord;
            this.mag[1] = (int)val;
        }
    }

    private static BigInteger valueOf(int[] val) {
        return val[0] > 0 ? new BigInteger(val, 1) : new BigInteger(val);
    }

    public BigInteger add(BigInteger val) {
        if (val.signum == 0) {
            return this;
        }
        if (this.signum == 0) {
            return val;
        }
        if (val.signum == this.signum) {
            return new BigInteger(BigInteger.add(this.mag, val.mag), this.signum);
        }
        int cmp = this.compareMagnitude(val);
        if (cmp == 0) {
            return ZERO;
        }
        int[] resultMag = cmp > 0 ? BigInteger.subtract(this.mag, val.mag) : BigInteger.subtract(val.mag, this.mag);
        resultMag = BigInteger.trustedStripLeadingZeroInts(resultMag);
        return new BigInteger(resultMag, cmp == this.signum ? 1 : -1);
    }

    BigInteger add(long val) {
        if (val == 0L) {
            return this;
        }
        if (this.signum == 0) {
            return BigInteger.valueOf(val);
        }
        if (Long.signum(val) == this.signum) {
            return new BigInteger(BigInteger.add(this.mag, Math.abs(val)), this.signum);
        }
        int cmp = this.compareMagnitude(val);
        if (cmp == 0) {
            return ZERO;
        }
        int[] resultMag = cmp > 0 ? BigInteger.subtract(this.mag, Math.abs(val)) : BigInteger.subtract(Math.abs(val), this.mag);
        resultMag = BigInteger.trustedStripLeadingZeroInts(resultMag);
        return new BigInteger(resultMag, cmp == this.signum ? 1 : -1);
    }

    private static int[] add(int[] x, long val) {
        int[] result;
        long sum = 0L;
        int xIndex = x.length;
        int highWord = (int)(val >>> 32);
        if (highWord == 0) {
            result = new int[xIndex];
            sum = ((long)x[--xIndex] & 0xFFFFFFFFL) + val;
            result[xIndex] = (int)sum;
        } else {
            if (xIndex == 1) {
                int[] result2 = new int[2];
                sum = val + ((long)x[0] & 0xFFFFFFFFL);
                result2[1] = (int)sum;
                result2[0] = (int)(sum >>> 32);
                return result2;
            }
            result = new int[xIndex];
            sum = ((long)x[--xIndex] & 0xFFFFFFFFL) + (val & 0xFFFFFFFFL);
            result[xIndex] = (int)sum;
            sum = ((long)x[--xIndex] & 0xFFFFFFFFL) + ((long)highWord & 0xFFFFFFFFL) + (sum >>> 32);
            result[xIndex] = (int)sum;
        }
        boolean carry = sum >>> 32 != 0L;
        while (xIndex > 0 && carry) {
            result[--xIndex] = x[xIndex] + 1;
            boolean bl = carry = result[--xIndex] == 0;
        }
        while (xIndex > 0) {
            result[--xIndex] = x[xIndex];
        }
        if (carry) {
            int[] bigger = new int[result.length + 1];
            System.arraycopy(result, 0, bigger, 1, result.length);
            bigger[0] = 1;
            return bigger;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private static int[] add(int[] x, int[] y) {
        block5: {
            if (x.length < y.length) {
                tmp = x;
                x = y;
                y = tmp;
            }
            xIndex = x.length;
            yIndex = y.length;
            result = new int[xIndex];
            sum = 0L;
            if (yIndex != 1) ** GOTO lbl15
            sum = ((long)x[--xIndex] & 0xFFFFFFFFL) + ((long)y[0] & 0xFFFFFFFFL);
            result[xIndex] = (int)sum;
            break block5;
lbl-1000:
            // 1 sources

            {
                sum = ((long)x[--xIndex] & 0xFFFFFFFFL) + ((long)y[--yIndex] & 0xFFFFFFFFL) + (sum >>> 32);
                result[xIndex] = (int)sum;
lbl15:
                // 2 sources

                ** while (yIndex > 0)
            }
        }
        carry = sum >>> 32 != 0L;
        while (xIndex > 0 && carry) {
            result[--xIndex] = x[xIndex] + 1;
            v0 = carry = result[--xIndex] == 0;
        }
        while (xIndex > 0) {
            result[--xIndex] = x[xIndex];
        }
        if (carry) {
            bigger = new int[result.length + 1];
            System.arraycopy(result, 0, bigger, 1, result.length);
            bigger[0] = 1;
            return bigger;
        }
        return result;
    }

    private static int[] subtract(long val, int[] little) {
        int highWord = (int)(val >>> 32);
        if (highWord == 0) {
            int[] result = new int[]{(int)(val - ((long)little[0] & 0xFFFFFFFFL))};
            return result;
        }
        int[] result = new int[2];
        if (little.length == 1) {
            long difference = ((long)((int)val) & 0xFFFFFFFFL) - ((long)little[0] & 0xFFFFFFFFL);
            result[1] = (int)difference;
            boolean borrow = difference >> 32 != 0L;
            result[0] = borrow ? highWord - 1 : highWord;
            return result;
        }
        long difference = ((long)((int)val) & 0xFFFFFFFFL) - ((long)little[1] & 0xFFFFFFFFL);
        result[1] = (int)difference;
        difference = ((long)highWord & 0xFFFFFFFFL) - ((long)little[0] & 0xFFFFFFFFL) + (difference >> 32);
        result[0] = (int)difference;
        return result;
    }

    private static int[] subtract(int[] big, long val) {
        int highWord = (int)(val >>> 32);
        int bigIndex = big.length;
        int[] result = new int[bigIndex];
        long difference = 0L;
        if (highWord == 0) {
            difference = ((long)big[--bigIndex] & 0xFFFFFFFFL) - val;
            result[bigIndex] = (int)difference;
        } else {
            difference = ((long)big[--bigIndex] & 0xFFFFFFFFL) - (val & 0xFFFFFFFFL);
            result[bigIndex] = (int)difference;
            difference = ((long)big[--bigIndex] & 0xFFFFFFFFL) - ((long)highWord & 0xFFFFFFFFL) + (difference >> 32);
            result[bigIndex] = (int)difference;
        }
        boolean borrow = difference >> 32 != 0L;
        while (bigIndex > 0 && borrow) {
            result[--bigIndex] = big[bigIndex] - 1;
            boolean bl = borrow = result[--bigIndex] == -1;
        }
        while (bigIndex > 0) {
            result[--bigIndex] = big[bigIndex];
        }
        return result;
    }

    public BigInteger subtract(BigInteger val) {
        if (val.signum == 0) {
            return this;
        }
        if (this.signum == 0) {
            return val.negate();
        }
        if (val.signum != this.signum) {
            return new BigInteger(BigInteger.add(this.mag, val.mag), this.signum);
        }
        int cmp = this.compareMagnitude(val);
        if (cmp == 0) {
            return ZERO;
        }
        int[] resultMag = cmp > 0 ? BigInteger.subtract(this.mag, val.mag) : BigInteger.subtract(val.mag, this.mag);
        resultMag = BigInteger.trustedStripLeadingZeroInts(resultMag);
        return new BigInteger(resultMag, cmp == this.signum ? 1 : -1);
    }

    private static int[] subtract(int[] big, int[] little) {
        int bigIndex = big.length;
        int[] result = new int[bigIndex];
        int littleIndex = little.length;
        long difference = 0L;
        while (littleIndex > 0) {
            difference = ((long)big[--bigIndex] & 0xFFFFFFFFL) - ((long)little[--littleIndex] & 0xFFFFFFFFL) + (difference >> 32);
            result[bigIndex] = (int)difference;
        }
        boolean borrow = difference >> 32 != 0L;
        while (bigIndex > 0 && borrow) {
            result[--bigIndex] = big[bigIndex] - 1;
            boolean bl = borrow = result[--bigIndex] == -1;
        }
        while (bigIndex > 0) {
            result[--bigIndex] = big[bigIndex];
        }
        return result;
    }

    public BigInteger multiply(BigInteger val) {
        if (val.signum == 0 || this.signum == 0) {
            return ZERO;
        }
        int xlen = this.mag.length;
        if (val == this && xlen > 20) {
            return this.square();
        }
        int ylen = val.mag.length;
        if (xlen < 80 || ylen < 80) {
            int resultSign;
            int n = resultSign = this.signum == val.signum ? 1 : -1;
            if (val.mag.length == 1) {
                return BigInteger.multiplyByInt(this.mag, val.mag[0], resultSign);
            }
            if (this.mag.length == 1) {
                return BigInteger.multiplyByInt(val.mag, this.mag[0], resultSign);
            }
            int[] result = this.multiplyToLen(this.mag, xlen, val.mag, ylen, null);
            result = BigInteger.trustedStripLeadingZeroInts(result);
            return new BigInteger(result, resultSign);
        }
        if (xlen < 240 && ylen < 240) {
            return BigInteger.multiplyKaratsuba(this, val);
        }
        return BigInteger.multiplyToomCook3(this, val);
    }

    private static BigInteger multiplyByInt(int[] x, int y, int sign) {
        if (IntegerHelper.bitCount(y) == 1) {
            return new BigInteger(BigInteger.shiftLeft(x, IntegerHelper.numberOfTrailingZeros(y)), sign);
        }
        int xlen = x.length;
        int[] rmag = new int[xlen + 1];
        long carry = 0L;
        long yl = (long)y & 0xFFFFFFFFL;
        int rstart = rmag.length - 1;
        int i = xlen - 1;
        while (i >= 0) {
            long product = ((long)x[i] & 0xFFFFFFFFL) * yl + carry;
            rmag[rstart--] = (int)product;
            carry = product >>> 32;
            --i;
        }
        if (carry == 0L) {
            rmag = Arrays.copyOfRange(rmag, 1, rmag.length);
        } else {
            rmag[rstart] = (int)carry;
        }
        return new BigInteger(rmag, sign);
    }

    BigInteger multiply(long v) {
        long product;
        int rsign;
        if (v == 0L || this.signum == 0) {
            return ZERO;
        }
        if (v == Long.MIN_VALUE) {
            return this.multiply(BigInteger.valueOf(v));
        }
        int n = rsign = v > 0L ? this.signum : -this.signum;
        if (v < 0L) {
            v = -v;
        }
        long dh = v >>> 32;
        long dl = v & 0xFFFFFFFFL;
        int xlen = this.mag.length;
        int[] value = this.mag;
        int[] rmag = dh == 0L ? new int[xlen + 1] : new int[xlen + 2];
        long carry = 0L;
        int rstart = rmag.length - 1;
        int i = xlen - 1;
        while (i >= 0) {
            product = ((long)value[i] & 0xFFFFFFFFL) * dl + carry;
            rmag[rstart--] = (int)product;
            carry = product >>> 32;
            --i;
        }
        rmag[rstart] = (int)carry;
        if (dh != 0L) {
            carry = 0L;
            rstart = rmag.length - 2;
            i = xlen - 1;
            while (i >= 0) {
                product = ((long)value[i] & 0xFFFFFFFFL) * dh + ((long)rmag[rstart] & 0xFFFFFFFFL) + carry;
                rmag[rstart--] = (int)product;
                carry = product >>> 32;
                --i;
            }
            rmag[0] = (int)carry;
        }
        if (carry == 0L) {
            rmag = Arrays.copyOfRange(rmag, 1, rmag.length);
        }
        return new BigInteger(rmag, rsign);
    }

    private int[] multiplyToLen(int[] x, int xlen, int[] y, int ylen, @Nullable int[] z) {
        int xstart = xlen - 1;
        int ystart = ylen - 1;
        if (z == null || z.length < xlen + ylen) {
            z = new int[xlen + ylen];
        }
        long carry = 0L;
        int j = ystart;
        int k = ystart + 1 + xstart;
        while (j >= 0) {
            long product = ((long)y[j] & 0xFFFFFFFFL) * ((long)x[xstart] & 0xFFFFFFFFL) + carry;
            z[k] = (int)product;
            carry = product >>> 32;
            --j;
            --k;
        }
        z[xstart] = (int)carry;
        int i = xstart - 1;
        while (i >= 0) {
            carry = 0L;
            int j2 = ystart;
            int k2 = ystart + 1 + i;
            while (j2 >= 0) {
                long product = ((long)y[j2] & 0xFFFFFFFFL) * ((long)x[i] & 0xFFFFFFFFL) + ((long)z[k2] & 0xFFFFFFFFL) + carry;
                z[k2] = (int)product;
                carry = product >>> 32;
                --j2;
                --k2;
            }
            z[i] = (int)carry;
            --i;
        }
        return z;
    }

    private static BigInteger multiplyKaratsuba(BigInteger x, BigInteger y) {
        int xlen = x.mag.length;
        int ylen = y.mag.length;
        int half = (Math.max(xlen, ylen) + 1) / 2;
        BigInteger xl = x.getLower(half);
        BigInteger xh = x.getUpper(half);
        BigInteger yl = y.getLower(half);
        BigInteger yh = y.getUpper(half);
        BigInteger p1 = xh.multiply(yh);
        BigInteger p2 = xl.multiply(yl);
        BigInteger p3 = xh.add(xl).multiply(yh.add(yl));
        BigInteger result = p1.shiftLeft(32 * half).add(p3.subtract(p1).subtract(p2)).shiftLeft(32 * half).add(p2);
        if (x.signum != y.signum) {
            return result.negate();
        }
        return result;
    }

    private static BigInteger multiplyToomCook3(BigInteger a, BigInteger b) {
        int alen = a.mag.length;
        int blen = b.mag.length;
        int largest = Math.max(alen, blen);
        int k = (largest + 2) / 3;
        int r = largest - 2 * k;
        BigInteger a2 = a.getToomSlice(k, r, 0, largest);
        BigInteger a1 = a.getToomSlice(k, r, 1, largest);
        BigInteger a0 = a.getToomSlice(k, r, 2, largest);
        BigInteger b2 = b.getToomSlice(k, r, 0, largest);
        BigInteger b1 = b.getToomSlice(k, r, 1, largest);
        BigInteger b0 = b.getToomSlice(k, r, 2, largest);
        BigInteger v0 = a0.multiply(b0);
        BigInteger da1 = a2.add(a0);
        BigInteger db1 = b2.add(b0);
        BigInteger vm1 = da1.subtract(a1).multiply(db1.subtract(b1));
        da1 = da1.add(a1);
        db1 = db1.add(b1);
        BigInteger v1 = da1.multiply(db1);
        BigInteger v2 = da1.add(a2).shiftLeft(1).subtract(a0).multiply(db1.add(b2).shiftLeft(1).subtract(b0));
        BigInteger vinf = a2.multiply(b2);
        BigInteger t2 = v2.subtract(vm1).exactDivideBy3();
        BigInteger tm1 = v1.subtract(vm1).shiftRight(1);
        BigInteger t1 = v1.subtract(v0);
        t2 = t2.subtract(t1).shiftRight(1);
        t1 = t1.subtract(tm1).subtract(vinf);
        t2 = t2.subtract(vinf.shiftLeft(1));
        tm1 = tm1.subtract(t2);
        int ss = k * 32;
        BigInteger result = vinf.shiftLeft(ss).add(t2).shiftLeft(ss).add(t1).shiftLeft(ss).add(tm1).shiftLeft(ss).add(v0);
        if (a.signum != b.signum) {
            return result.negate();
        }
        return result;
    }

    private BigInteger getToomSlice(int lowerSize, int upperSize, int slice, int fullsize) {
        int end;
        int start;
        int len = this.mag.length;
        int offset = fullsize - len;
        if (slice == 0) {
            start = 0 - offset;
            end = upperSize - 1 - offset;
        } else {
            start = upperSize + (slice - 1) * lowerSize - offset;
            end = start + lowerSize - 1;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            return ZERO;
        }
        int sliceSize = end - start + 1;
        if (sliceSize <= 0) {
            return ZERO;
        }
        if (start == 0 && sliceSize >= len) {
            return this.abs();
        }
        int[] intSlice = new int[sliceSize];
        System.arraycopy(this.mag, start, intSlice, 0, sliceSize);
        return new BigInteger(BigInteger.trustedStripLeadingZeroInts(intSlice), 1);
    }

    private BigInteger exactDivideBy3() {
        int len = this.mag.length;
        int[] result = new int[len];
        long borrow = 0L;
        int i = len - 1;
        while (i >= 0) {
            long x = (long)this.mag[i] & 0xFFFFFFFFL;
            long w = x - borrow;
            borrow = borrow > x ? 1L : 0L;
            long q = w * 0xAAAAAAABL & 0xFFFFFFFFL;
            result[i] = (int)q;
            if (q >= 0x55555556L) {
                ++borrow;
                if (q >= 0xAAAAAAABL) {
                    ++borrow;
                }
            }
            --i;
        }
        result = BigInteger.trustedStripLeadingZeroInts(result);
        return new BigInteger(result, this.signum);
    }

    private BigInteger getLower(int n) {
        int len = this.mag.length;
        if (len <= n) {
            return this.abs();
        }
        int[] lowerInts = new int[n];
        System.arraycopy(this.mag, len - n, lowerInts, 0, n);
        return new BigInteger(BigInteger.trustedStripLeadingZeroInts(lowerInts), 1);
    }

    private BigInteger getUpper(int n) {
        int len = this.mag.length;
        if (len <= n) {
            return ZERO;
        }
        int upperLen = len - n;
        int[] upperInts = new int[upperLen];
        System.arraycopy(this.mag, 0, upperInts, 0, upperLen);
        return new BigInteger(BigInteger.trustedStripLeadingZeroInts(upperInts), 1);
    }

    private BigInteger square() {
        if (this.signum == 0) {
            return ZERO;
        }
        int len = this.mag.length;
        if (len < 128) {
            int[] z = BigInteger.squareToLen(this.mag, len, null);
            return new BigInteger(BigInteger.trustedStripLeadingZeroInts(z), 1);
        }
        if (len < 216) {
            return this.squareKaratsuba();
        }
        return this.squareToomCook3();
    }

    private static final int[] squareToLen(int[] x, int len, @Nullable int[] z) {
        int zlen = len << 1;
        if (z == null || z.length < zlen) {
            z = new int[zlen];
        }
        int lastProductLowWord = 0;
        int j = 0;
        int i = 0;
        while (j < len) {
            long piece = (long)x[j] & 0xFFFFFFFFL;
            long product = piece * piece;
            z[i++] = lastProductLowWord << 31 | (int)(product >>> 33);
            z[i++] = (int)(product >>> 1);
            lastProductLowWord = (int)product;
            ++j;
        }
        int i2 = len;
        int offset = 1;
        while (i2 > 0) {
            int t = x[i2 - 1];
            t = BigInteger.mulAdd(z, x, offset, i2 - 1, t);
            BigInteger.addOne(z, offset - 1, i2, t);
            --i2;
            offset += 2;
        }
        BigInteger.primitiveLeftShift(z, zlen, 1);
        int n = zlen - 1;
        z[n] = z[n] | x[len - 1] & 1;
        return z;
    }

    private BigInteger squareKaratsuba() {
        int half = (this.mag.length + 1) / 2;
        BigInteger xl = this.getLower(half);
        BigInteger xh = this.getUpper(half);
        BigInteger xhs = xh.square();
        BigInteger xls = xl.square();
        return xhs.shiftLeft(half * 32).add(xl.add(xh).square().subtract(xhs.add(xls))).shiftLeft(half * 32).add(xls);
    }

    private BigInteger squareToomCook3() {
        int len = this.mag.length;
        int k = (len + 2) / 3;
        int r = len - 2 * k;
        BigInteger a2 = this.getToomSlice(k, r, 0, len);
        BigInteger a1 = this.getToomSlice(k, r, 1, len);
        BigInteger a0 = this.getToomSlice(k, r, 2, len);
        BigInteger v0 = a0.square();
        BigInteger da1 = a2.add(a0);
        BigInteger vm1 = da1.subtract(a1).square();
        da1 = da1.add(a1);
        BigInteger v1 = da1.square();
        BigInteger vinf = a2.square();
        BigInteger v2 = da1.add(a2).shiftLeft(1).subtract(a0).square();
        BigInteger t2 = v2.subtract(vm1).exactDivideBy3();
        BigInteger tm1 = v1.subtract(vm1).shiftRight(1);
        BigInteger t1 = v1.subtract(v0);
        t2 = t2.subtract(t1).shiftRight(1);
        t1 = t1.subtract(tm1).subtract(vinf);
        t2 = t2.subtract(vinf.shiftLeft(1));
        tm1 = tm1.subtract(t2);
        int ss = k * 32;
        return vinf.shiftLeft(ss).add(t2).shiftLeft(ss).add(t1).shiftLeft(ss).add(tm1).shiftLeft(ss).add(v0);
    }

    public BigInteger divide(BigInteger val) {
        if (val.mag.length < 80 || this.mag.length - val.mag.length < 40) {
            return this.divideKnuth(val);
        }
        return this.divideBurnikelZiegler(val);
    }

    private BigInteger divideKnuth(BigInteger val) {
        MutableBigInteger q = new MutableBigInteger();
        MutableBigInteger a = new MutableBigInteger(this.mag);
        MutableBigInteger b = new MutableBigInteger(val.mag);
        a.divideKnuth(b, q, false);
        return q.toBigInteger(this.signum * val.signum);
    }

    public BigInteger[] divideAndRemainder(BigInteger val) {
        if (val.mag.length < 80 || this.mag.length - val.mag.length < 40) {
            return this.divideAndRemainderKnuth(val);
        }
        return this.divideAndRemainderBurnikelZiegler(val);
    }

    private BigInteger[] divideAndRemainderKnuth(BigInteger val) {
        BigInteger[] result = new BigInteger[2];
        MutableBigInteger q = new MutableBigInteger();
        MutableBigInteger a = new MutableBigInteger(this.mag);
        MutableBigInteger b = new MutableBigInteger(val.mag);
        MutableBigInteger r = a.divideKnuth(b, q);
        result[0] = q.toBigInteger(this.signum == val.signum ? 1 : -1);
        result[1] = r.toBigInteger(this.signum);
        return result;
    }

    public BigInteger remainder(BigInteger val) {
        if (val.mag.length < 80 || this.mag.length - val.mag.length < 40) {
            return this.remainderKnuth(val);
        }
        return this.remainderBurnikelZiegler(val);
    }

    private BigInteger remainderKnuth(BigInteger val) {
        MutableBigInteger q = new MutableBigInteger();
        MutableBigInteger a = new MutableBigInteger(this.mag);
        MutableBigInteger b = new MutableBigInteger(val.mag);
        return a.divideKnuth(b, q).toBigInteger(this.signum);
    }

    private BigInteger divideBurnikelZiegler(BigInteger val) {
        return this.divideAndRemainderBurnikelZiegler(val)[0];
    }

    private BigInteger remainderBurnikelZiegler(BigInteger val) {
        return this.divideAndRemainderBurnikelZiegler(val)[1];
    }

    private BigInteger[] divideAndRemainderBurnikelZiegler(BigInteger val) {
        MutableBigInteger q = new MutableBigInteger();
        MutableBigInteger r = new MutableBigInteger(this).divideAndRemainderBurnikelZiegler(new MutableBigInteger(val), q);
        BigInteger qBigInt = q.isZero() ? ZERO : q.toBigInteger(this.signum * val.signum);
        BigInteger rBigInt = r.isZero() ? ZERO : r.toBigInteger(this.signum);
        return new BigInteger[]{qBigInt, rBigInt};
    }

    public BigInteger pow(int exponent) {
        int remainingBits;
        if (exponent < 0) {
            throw new ArithmeticException("Negative exponent");
        }
        if (this.signum == 0) {
            return exponent == 0 ? ONE : this;
        }
        BigInteger partToSquare = this.abs();
        int powersOfTwo = partToSquare.getLowestSetBit();
        long bitsToShift = (long)powersOfTwo * (long)exponent;
        if (bitsToShift > Integer.MAX_VALUE) {
            BigInteger.reportOverflow();
        }
        if (powersOfTwo > 0) {
            remainingBits = (partToSquare = partToSquare.shiftRight(powersOfTwo)).bitLength();
            if (remainingBits == 1) {
                if (this.signum < 0 && (exponent & 1) == 1) {
                    return NEGATIVE_ONE.shiftLeft(powersOfTwo * exponent);
                }
                return ONE.shiftLeft(powersOfTwo * exponent);
            }
        } else {
            remainingBits = partToSquare.bitLength();
            if (remainingBits == 1) {
                if (this.signum < 0 && (exponent & 1) == 1) {
                    return NEGATIVE_ONE;
                }
                return ONE;
            }
        }
        long scaleFactor = (long)remainingBits * (long)exponent;
        if (partToSquare.mag.length == 1 && scaleFactor <= 62L) {
            int newSign = this.signum < 0 && (exponent & 1) == 1 ? -1 : 1;
            long result = 1L;
            long baseToPow2 = (long)partToSquare.mag[0] & 0xFFFFFFFFL;
            int workingExponent = exponent;
            while (workingExponent != 0) {
                if ((workingExponent & 1) == 1) {
                    result *= baseToPow2;
                }
                if ((workingExponent >>>= 1) == 0) continue;
                baseToPow2 *= baseToPow2;
            }
            if (powersOfTwo > 0) {
                if (bitsToShift + scaleFactor <= 62L) {
                    return BigInteger.valueOf((result << (int)bitsToShift) * (long)newSign);
                }
                return BigInteger.valueOf(result * (long)newSign).shiftLeft((int)bitsToShift);
            }
            return BigInteger.valueOf(result * (long)newSign);
        }
        BigInteger answer = ONE;
        int workingExponent = exponent;
        while (workingExponent != 0) {
            if ((workingExponent & 1) == 1) {
                answer = answer.multiply(partToSquare);
            }
            if ((workingExponent >>>= 1) == 0) continue;
            partToSquare = partToSquare.square();
        }
        if (powersOfTwo > 0) {
            answer = answer.shiftLeft(powersOfTwo * exponent);
        }
        if (this.signum < 0 && (exponent & 1) == 1) {
            return answer.negate();
        }
        return answer;
    }

    public BigInteger gcd(BigInteger val) {
        if (val.signum == 0) {
            return this.abs();
        }
        if (this.signum == 0) {
            return val.abs();
        }
        MutableBigInteger a = new MutableBigInteger(this);
        MutableBigInteger b = new MutableBigInteger(val);
        MutableBigInteger result = a.hybridGCD(b);
        return result.toBigInteger(1);
    }

    static int bitLengthForInt(int n) {
        return 32 - IntegerHelper.numberOfLeadingZeros(n);
    }

    private static int[] leftShift(int[] a, int len, int n) {
        int nInts = n >>> 5;
        int nBits = n & 0x1F;
        int bitsInHighWord = BigInteger.bitLengthForInt(a[0]);
        if (n <= 32 - bitsInHighWord) {
            BigInteger.primitiveLeftShift(a, len, nBits);
            return a;
        }
        if (nBits <= 32 - bitsInHighWord) {
            int[] result = new int[nInts + len];
            System.arraycopy(a, 0, result, 0, len);
            BigInteger.primitiveLeftShift(result, result.length, nBits);
            return result;
        }
        int[] result = new int[nInts + len + 1];
        System.arraycopy(a, 0, result, 0, len);
        BigInteger.primitiveRightShift(result, result.length, 32 - nBits);
        return result;
    }

    static void primitiveRightShift(int[] a, int len, int n) {
        int n2 = 32 - n;
        int i = len - 1;
        int c = a[i];
        while (i > 0) {
            int b = c;
            c = a[i - 1];
            a[i] = c << n2 | b >>> n;
            --i;
        }
        a[0] = a[0] >>> n;
    }

    static void primitiveLeftShift(int[] a, int len, int n) {
        if (len == 0 || n == 0) {
            return;
        }
        int n2 = 32 - n;
        int i = 0;
        int c = a[i];
        int m = i + len - 1;
        while (i < m) {
            int b = c;
            c = a[i + 1];
            a[i] = b << n | c >>> n2;
            ++i;
        }
        int n3 = len - 1;
        a[n3] = a[n3] << n;
    }

    private static int bitLength(int[] val, int len) {
        if (len == 0) {
            return 0;
        }
        return (len - 1 << 5) + BigInteger.bitLengthForInt(val[0]);
    }

    public BigInteger abs() {
        return this.signum >= 0 ? this : this.negate();
    }

    public BigInteger negate() {
        return new BigInteger(this.mag, -this.signum);
    }

    public int signum() {
        return this.signum;
    }

    public BigInteger mod(BigInteger m) {
        if (m.signum <= 0) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        BigInteger result = this.remainder(m);
        return result.signum >= 0 ? result : result.add(m);
    }

    public BigInteger modPow(BigInteger exponent, BigInteger m) {
        BigInteger result;
        BigInteger base;
        if (m.signum <= 0) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        if (exponent.signum == 0) {
            return m.equals(ONE) ? ZERO : ONE;
        }
        if (this.equals(ONE)) {
            return m.equals(ONE) ? ZERO : ONE;
        }
        if (this.equals(ZERO) && exponent.signum >= 0) {
            return ZERO;
        }
        if (this.equals(negConst[1]) && !exponent.testBit(0)) {
            return m.equals(ONE) ? ZERO : ONE;
        }
        boolean invertResult = exponent.signum < 0;
        if (invertResult) {
            exponent = exponent.negate();
        }
        BigInteger bigInteger = base = this.signum < 0 || this.compareTo(m) >= 0 ? this.mod(m) : this;
        if (m.testBit(0)) {
            result = base.oddModPow(exponent, m);
        } else {
            int p = m.getLowestSetBit();
            BigInteger m1 = m.shiftRight(p);
            BigInteger m2 = ONE.shiftLeft(p);
            BigInteger base2 = this.signum < 0 || this.compareTo(m1) >= 0 ? this.mod(m1) : this;
            BigInteger a1 = m1.equals(ONE) ? ZERO : base2.oddModPow(exponent, m1);
            BigInteger a2 = base.modPow2(exponent, p);
            BigInteger y1 = m2.modInverse(m1);
            BigInteger y2 = m1.modInverse(m2);
            if (m.mag.length < 0x2000000) {
                result = a1.multiply(m2).multiply(y1).add(a2.multiply(m1).multiply(y2)).mod(m);
            } else {
                MutableBigInteger t1 = new MutableBigInteger();
                new MutableBigInteger(a1.multiply(m2)).multiply(new MutableBigInteger(y1), t1);
                MutableBigInteger t2 = new MutableBigInteger();
                new MutableBigInteger(a2.multiply(m1)).multiply(new MutableBigInteger(y2), t2);
                t1.add(t2);
                MutableBigInteger q = new MutableBigInteger();
                result = t1.divide(new MutableBigInteger(m), q).toBigInteger();
            }
        }
        return invertResult ? result.modInverse(m) : result;
    }

    private BigInteger oddModPow(BigInteger y, BigInteger z) {
        int i;
        if (y.equals(ONE)) {
            return this;
        }
        if (this.signum == 0) {
            return ZERO;
        }
        int[] base = (int[])this.mag.clone();
        int[] exp = y.mag;
        int[] mod = z.mag;
        int modLen = mod.length;
        int wbits = 0;
        int ebits = BigInteger.bitLength(exp, exp.length);
        if (ebits != 17 || exp[0] != 65537) {
            while (ebits > bnExpModThreshTable[wbits]) {
                ++wbits;
            }
        }
        int tblmask = 1 << wbits;
        int[][] table = new int[tblmask][];
        int i2 = 0;
        while (i2 < tblmask) {
            table[i2] = new int[modLen];
            ++i2;
        }
        int inv = -MutableBigInteger.inverseMod32(mod[modLen - 1]);
        int[] a = BigInteger.leftShift(base, base.length, modLen << 5);
        MutableBigInteger q = new MutableBigInteger();
        MutableBigInteger a2 = new MutableBigInteger(a);
        MutableBigInteger b2 = new MutableBigInteger(mod);
        MutableBigInteger r = a2.divide(b2, q);
        table[0] = r.toIntArray();
        if (table[0].length < modLen) {
            int offset = modLen - table[0].length;
            int[] t2 = new int[modLen];
            i = 0;
            while (i < table[0].length) {
                t2[i + offset] = table[0][i];
                ++i;
            }
            table[0] = t2;
        }
        int[] b = BigInteger.squareToLen(table[0], modLen, null);
        b = BigInteger.montReduce(b, mod, modLen, inv);
        int[] t = Arrays.copyOf(b, modLen);
        i = 1;
        while (i < tblmask) {
            int[] prod = this.multiplyToLen(t, modLen, table[i - 1], modLen, null);
            table[i] = BigInteger.montReduce(prod, mod, modLen, inv);
            ++i;
        }
        int bitpos = 1 << (ebits - 1 & 0x1F);
        int buf = 0;
        int elen = exp.length;
        int eIndex = 0;
        int i3 = 0;
        while (i3 <= wbits) {
            buf = buf << 1 | ((exp[eIndex] & bitpos) != 0 ? 1 : 0);
            if ((bitpos >>>= 1) == 0) {
                ++eIndex;
                bitpos = Integer.MIN_VALUE;
                --elen;
            }
            ++i3;
        }
        int multpos = ebits--;
        boolean isone = true;
        multpos = ebits - wbits;
        while ((buf & 1) == 0) {
            buf >>>= 1;
            ++multpos;
        }
        int[] mult = table[buf >>> 1];
        buf = 0;
        if (multpos == ebits) {
            isone = false;
        }
        while (true) {
            --ebits;
            buf <<= 1;
            if (elen != 0) {
                buf |= (exp[eIndex] & bitpos) != 0 ? 1 : 0;
                if ((bitpos >>>= 1) == 0) {
                    ++eIndex;
                    bitpos = Integer.MIN_VALUE;
                    --elen;
                }
            }
            if ((buf & tblmask) != 0) {
                multpos = ebits - wbits;
                while ((buf & 1) == 0) {
                    buf >>>= 1;
                    ++multpos;
                }
                mult = table[buf >>> 1];
                buf = 0;
            }
            if (ebits == multpos) {
                if (isone) {
                    b = (int[])mult.clone();
                    isone = false;
                } else {
                    t = b;
                    a = this.multiplyToLen(t, modLen, mult, modLen, a);
                    a = BigInteger.montReduce(a, mod, modLen, inv);
                    t = a;
                    a = b;
                    b = t;
                }
            }
            if (ebits == 0) break;
            if (isone) continue;
            t = b;
            a = BigInteger.squareToLen(t, modLen, a);
            a = BigInteger.montReduce(a, mod, modLen, inv);
            t = a;
            a = b;
            b = t;
        }
        int[] t2 = new int[2 * modLen];
        System.arraycopy(b, 0, t2, modLen, modLen);
        b = BigInteger.montReduce(t2, mod, modLen, inv);
        t2 = Arrays.copyOf(b, modLen);
        return new BigInteger(1, t2);
    }

    private static int[] montReduce(int[] n, int[] mod, int mlen, int inv) {
        int c = 0;
        int len = mlen;
        int offset = 0;
        do {
            int nEnd = n[n.length - 1 - offset];
            int carry = BigInteger.mulAdd(n, mod, offset, mlen, inv * nEnd);
            c += BigInteger.addOne(n, offset, mlen, carry);
            ++offset;
        } while (--len > 0);
        while (c > 0) {
            c += BigInteger.subN(n, mod, mlen);
        }
        while (BigInteger.intArrayCmpToLen(n, mod, mlen) >= 0) {
            BigInteger.subN(n, mod, mlen);
        }
        return n;
    }

    private static int intArrayCmpToLen(int[] arg1, int[] arg2, int len) {
        int i = 0;
        while (i < len) {
            long b1 = (long)arg1[i] & 0xFFFFFFFFL;
            long b2 = (long)arg2[i] & 0xFFFFFFFFL;
            if (b1 < b2) {
                return -1;
            }
            if (b1 > b2) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    private static int subN(int[] a, int[] b, int len) {
        long sum = 0L;
        while (--len >= 0) {
            sum = ((long)a[len] & 0xFFFFFFFFL) - ((long)b[len] & 0xFFFFFFFFL) + (sum >> 32);
            a[len] = (int)sum;
        }
        return (int)(sum >> 32);
    }

    static int mulAdd(int[] out, int[] in, int offset, int len, int k) {
        long kLong = (long)k & 0xFFFFFFFFL;
        long carry = 0L;
        offset = out.length - offset - 1;
        int j = len - 1;
        while (j >= 0) {
            long product = ((long)in[j] & 0xFFFFFFFFL) * kLong + ((long)out[offset] & 0xFFFFFFFFL) + carry;
            out[offset--] = (int)product;
            carry = product >>> 32;
            --j;
        }
        return (int)carry;
    }

    /*
     * Unable to fully structure code
     */
    static int addOne(int[] a, int offset, int mlen, int carry) {
        offset = a.length - 1 - mlen - offset;
        t = ((long)a[offset] & 0xFFFFFFFFL) + ((long)carry & 0xFFFFFFFFL);
        a[offset] = (int)t;
        if (t >>> 32 != 0L) ** GOTO lbl12
        return 0;
lbl-1000:
        // 1 sources

        {
            if (--offset < 0) {
                return 1;
            }
            v0 = offset;
            a[v0] = a[v0] + 1;
            if (a[offset] == 0) continue;
            return 0;
lbl12:
            // 2 sources

            ** while (--mlen >= 0)
        }
lbl13:
        // 1 sources

        return 1;
    }

    private BigInteger modPow2(BigInteger exponent, int p) {
        BigInteger result = ONE;
        BigInteger baseToPow2 = this.mod2(p);
        int expOffset = 0;
        int limit = exponent.bitLength();
        if (this.testBit(0)) {
            limit = p - 1 < limit ? p - 1 : limit;
        }
        while (expOffset < limit) {
            if (exponent.testBit(expOffset)) {
                result = result.multiply(baseToPow2).mod2(p);
            }
            if (++expOffset >= limit) continue;
            baseToPow2 = baseToPow2.square().mod2(p);
        }
        return result;
    }

    private BigInteger mod2(int p) {
        if (this.bitLength() <= p) {
            return this;
        }
        int numInts = p + 31 >>> 5;
        int[] mag = new int[numInts];
        System.arraycopy(this.mag, this.mag.length - numInts, mag, 0, numInts);
        int excessBits = (numInts << 5) - p;
        mag[0] = (int)((long)mag[0] & (1L << 32 - excessBits) - 1L);
        return mag[0] == 0 ? new BigInteger(1, mag) : new BigInteger(mag, 1);
    }

    public BigInteger modInverse(BigInteger m) {
        if (m.signum != 1) {
            throw new ArithmeticException("BigInteger: modulus not positive");
        }
        if (m.equals(ONE)) {
            return ZERO;
        }
        BigInteger modVal = this;
        if (this.signum < 0 || this.compareMagnitude(m) >= 0) {
            modVal = this.mod(m);
        }
        if (modVal.equals(ONE)) {
            return ONE;
        }
        MutableBigInteger a = new MutableBigInteger(modVal);
        MutableBigInteger b = new MutableBigInteger(m);
        MutableBigInteger result = a.mutableModInverse(b);
        return result.toBigInteger(1);
    }

    public BigInteger shiftLeft(int n) {
        if (this.signum == 0) {
            return ZERO;
        }
        if (n > 0) {
            return new BigInteger(BigInteger.shiftLeft(this.mag, n), this.signum);
        }
        if (n == 0) {
            return this;
        }
        return this.shiftRightImpl(-n);
    }

    private static int[] shiftLeft(int[] mag, int n) {
        int nInts = n >>> 5;
        int nBits = n & 0x1F;
        int magLen = mag.length;
        int[] newMag = null;
        if (nBits == 0) {
            newMag = new int[magLen + nInts];
            System.arraycopy(mag, 0, newMag, 0, magLen);
        } else {
            int i = 0;
            int nBits2 = 32 - nBits;
            int highBits = mag[0] >>> nBits2;
            if (highBits != 0) {
                newMag = new int[magLen + nInts + 1];
                newMag[i++] = highBits;
            } else {
                newMag = new int[magLen + nInts];
            }
            int j = 0;
            while (j < magLen - 1) {
                newMag[i++] = mag[j++] << nBits | mag[j] >>> nBits2;
            }
            newMag[i] = mag[j] << nBits;
        }
        return newMag;
    }

    public BigInteger shiftRight(int n) {
        if (this.signum == 0) {
            return ZERO;
        }
        if (n > 0) {
            return this.shiftRightImpl(n);
        }
        if (n == 0) {
            return this;
        }
        return new BigInteger(BigInteger.shiftLeft(this.mag, -n), this.signum);
    }

    private BigInteger shiftRightImpl(int n) {
        int nInts = n >>> 5;
        int nBits = n & 0x1F;
        int magLen = this.mag.length;
        int[] newMag = null;
        if (nInts >= magLen) {
            return this.signum >= 0 ? ZERO : negConst[1];
        }
        if (nBits == 0) {
            int newMagLen = magLen - nInts;
            newMag = Arrays.copyOf(this.mag, newMagLen);
        } else {
            int i = 0;
            int highBits = this.mag[0] >>> nBits;
            if (highBits != 0) {
                newMag = new int[magLen - nInts];
                newMag[i++] = highBits;
            } else {
                newMag = new int[magLen - nInts - 1];
            }
            int nBits2 = 32 - nBits;
            int j = 0;
            while (j < magLen - nInts - 1) {
                newMag[i++] = this.mag[j++] << nBits2 | this.mag[j] >>> nBits;
            }
        }
        if (this.signum < 0) {
            boolean onesLost = false;
            int i = magLen - 1;
            int j = magLen - nInts;
            while (i >= j && !onesLost) {
                onesLost = this.mag[i] != 0;
                --i;
            }
            if (!onesLost && nBits != 0) {
                boolean bl = onesLost = this.mag[magLen - nInts - 1] << 32 - nBits != 0;
            }
            if (onesLost) {
                newMag = this.javaIncrement(newMag);
            }
        }
        return new BigInteger(newMag, this.signum);
    }

    int[] javaIncrement(int[] val) {
        int lastSum = 0;
        int i = val.length - 1;
        while (i >= 0 && lastSum == 0) {
            int n = i--;
            int n2 = val[n] + 1;
            val[n] = n2;
            lastSum = n2;
        }
        if (lastSum == 0) {
            val = new int[val.length + 1];
            val[0] = 1;
        }
        return val;
    }

    public BigInteger and(BigInteger val) {
        int[] result = new int[Math.max(this.intLength(), val.intLength())];
        int i = 0;
        while (i < result.length) {
            result[i] = this.getInt(result.length - i - 1) & val.getInt(result.length - i - 1);
            ++i;
        }
        return BigInteger.valueOf(result);
    }

    public BigInteger or(BigInteger val) {
        int[] result = new int[Math.max(this.intLength(), val.intLength())];
        int i = 0;
        while (i < result.length) {
            result[i] = this.getInt(result.length - i - 1) | val.getInt(result.length - i - 1);
            ++i;
        }
        return BigInteger.valueOf(result);
    }

    public BigInteger xor(BigInteger val) {
        int[] result = new int[Math.max(this.intLength(), val.intLength())];
        int i = 0;
        while (i < result.length) {
            result[i] = this.getInt(result.length - i - 1) ^ val.getInt(result.length - i - 1);
            ++i;
        }
        return BigInteger.valueOf(result);
    }

    public BigInteger not() {
        int[] result = new int[this.intLength()];
        int i = 0;
        while (i < result.length) {
            result[i] = ~this.getInt(result.length - i - 1);
            ++i;
        }
        return BigInteger.valueOf(result);
    }

    public BigInteger andNot(BigInteger val) {
        int[] result = new int[Math.max(this.intLength(), val.intLength())];
        int i = 0;
        while (i < result.length) {
            result[i] = this.getInt(result.length - i - 1) & ~val.getInt(result.length - i - 1);
            ++i;
        }
        return BigInteger.valueOf(result);
    }

    public boolean testBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        return (this.getInt(n >>> 5) & 1 << (n & 0x1F)) != 0;
    }

    public BigInteger setBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        int intNum = n >>> 5;
        int[] result = new int[Math.max(this.intLength(), intNum + 2)];
        int i = 0;
        while (i < result.length) {
            result[result.length - i - 1] = this.getInt(i);
            ++i;
        }
        int n2 = result.length - intNum - 1;
        result[n2] = result[n2] | 1 << (n & 0x1F);
        return BigInteger.valueOf(result);
    }

    public BigInteger clearBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        int intNum = n >>> 5;
        int[] result = new int[Math.max(this.intLength(), (n + 1 >>> 5) + 1)];
        int i = 0;
        while (i < result.length) {
            result[result.length - i - 1] = this.getInt(i);
            ++i;
        }
        int n2 = result.length - intNum - 1;
        result[n2] = result[n2] & ~(1 << (n & 0x1F));
        return BigInteger.valueOf(result);
    }

    public BigInteger flipBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
        int intNum = n >>> 5;
        int[] result = new int[Math.max(this.intLength(), intNum + 2)];
        int i = 0;
        while (i < result.length) {
            result[result.length - i - 1] = this.getInt(i);
            ++i;
        }
        int n2 = result.length - intNum - 1;
        result[n2] = result[n2] ^ 1 << (n & 0x1F);
        return BigInteger.valueOf(result);
    }

    public int getLowestSetBit() {
        int lsb = this.lowestSetBit - 2;
        if (lsb == -2) {
            lsb = 0;
            if (this.signum == 0) {
                --lsb;
            } else {
                int b;
                int i = 0;
                while ((b = this.getInt(i)) == 0) {
                    ++i;
                }
                lsb += (i << 5) + IntegerHelper.numberOfTrailingZeros(b);
            }
            this.lowestSetBit = lsb + 2;
        }
        return lsb;
    }

    public int bitLength() {
        int n = this.bitLength - 1;
        if (n == -1) {
            int[] m = this.mag;
            int len = m.length;
            if (len == 0) {
                n = 0;
            } else {
                int magBitLength = (len - 1 << 5) + BigInteger.bitLengthForInt(this.mag[0]);
                if (this.signum < 0) {
                    boolean pow2 = IntegerHelper.bitCount(this.mag[0]) == 1;
                    int i = 1;
                    while (i < len && pow2) {
                        pow2 = this.mag[i] == 0;
                        ++i;
                    }
                    n = pow2 ? magBitLength - 1 : magBitLength;
                } else {
                    n = magBitLength;
                }
            }
            this.bitLength = n + 1;
        }
        return n;
    }

    public int bitCount() {
        int bc = this.bitCount - 1;
        if (bc == -1) {
            bc = 0;
            int i = 0;
            while (i < this.mag.length) {
                bc += IntegerHelper.bitCount(this.mag[i]);
                ++i;
            }
            if (this.signum < 0) {
                int magTrailingZeroCount = 0;
                int j = this.mag.length - 1;
                while (this.mag[j] == 0) {
                    magTrailingZeroCount += 32;
                    --j;
                }
                bc += (magTrailingZeroCount += IntegerHelper.numberOfTrailingZeros(this.mag[j])) - 1;
            }
            this.bitCount = bc + 1;
        }
        return bc;
    }

    @Override
    public int compareTo(BigInteger val) {
        if (this.signum == val.signum) {
            switch (this.signum) {
                case 1: {
                    return this.compareMagnitude(val);
                }
                case -1: {
                    return val.compareMagnitude(this);
                }
            }
            return 0;
        }
        return this.signum > val.signum ? 1 : -1;
    }

    final int compareMagnitude(BigInteger val) {
        int[] m1 = this.mag;
        int len1 = m1.length;
        int[] m2 = val.mag;
        int len2 = m2.length;
        if (len1 < len2) {
            return -1;
        }
        if (len1 > len2) {
            return 1;
        }
        int i = 0;
        while (i < len1) {
            int a = m1[i];
            int b = m2[i];
            if (a != b) {
                return ((long)a & 0xFFFFFFFFL) < ((long)b & 0xFFFFFFFFL) ? -1 : 1;
            }
            ++i;
        }
        return 0;
    }

    final int compareMagnitude(long val) {
        int highWord;
        assert (val != Long.MIN_VALUE);
        int[] m1 = this.mag;
        int len = m1.length;
        if (len > 2) {
            return 1;
        }
        if (val < 0L) {
            val = -val;
        }
        if ((highWord = (int)(val >>> 32)) == 0) {
            if (len < 1) {
                return -1;
            }
            if (len > 1) {
                return 1;
            }
            int a = m1[0];
            int b = (int)val;
            if (a != b) {
                return ((long)a & 0xFFFFFFFFL) < ((long)b & 0xFFFFFFFFL) ? -1 : 1;
            }
            return 0;
        }
        if (len < 2) {
            return -1;
        }
        int a = m1[0];
        int b = highWord;
        if (a != b) {
            return ((long)a & 0xFFFFFFFFL) < ((long)b & 0xFFFFFFFFL) ? -1 : 1;
        }
        a = m1[1];
        b = (int)val;
        if (a != b) {
            return ((long)a & 0xFFFFFFFFL) < ((long)b & 0xFFFFFFFFL) ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(@Nullable Object x) {
        if (x == this) {
            return true;
        }
        if (!(x instanceof BigInteger)) {
            return false;
        }
        BigInteger xInt = (BigInteger)x;
        if (xInt.signum != this.signum) {
            return false;
        }
        int[] m = this.mag;
        int len = m.length;
        int[] xm = xInt.mag;
        if (len != xm.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (xm[i] != m[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public BigInteger min(BigInteger val) {
        return this.compareTo(val) < 0 ? this : val;
    }

    public BigInteger max(BigInteger val) {
        return this.compareTo(val) > 0 ? this : val;
    }

    public int hashCode() {
        int hashCode = 0;
        int i = 0;
        while (i < this.mag.length) {
            hashCode = (int)((long)(31 * hashCode) + ((long)this.mag[i] & 0xFFFFFFFFL));
            ++i;
        }
        return hashCode * this.signum;
    }

    public String toString(int radix) {
        if (this.signum == 0) {
            return "0";
        }
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        if (this.mag.length <= 20) {
            return this.smallToString(radix);
        }
        StringBuilder sb = new StringBuilder();
        if (this.signum < 0) {
            BigInteger.toString(this.negate(), sb, radix, 0);
            sb.insert(0, '-');
        } else {
            BigInteger.toString(this, sb, radix, 0);
        }
        return sb.toString();
    }

    private String smallToString(int radix) {
        if (this.signum == 0) {
            return "0";
        }
        int maxNumDigitGroups = (4 * this.mag.length + 6) / 7;
        String[] digitGroup = new String[maxNumDigitGroups];
        BigInteger tmp = this.abs();
        int numGroups = 0;
        while (tmp.signum != 0) {
            BigInteger d = longRadix[radix];
            MutableBigInteger q = new MutableBigInteger();
            MutableBigInteger a = new MutableBigInteger(tmp.mag);
            MutableBigInteger b = new MutableBigInteger(d.mag);
            MutableBigInteger r = a.divide(b, q);
            BigInteger q2 = q.toBigInteger(tmp.signum * d.signum);
            BigInteger r2 = r.toBigInteger(tmp.signum * d.signum);
            digitGroup[numGroups++] = Long.toString(r2.longValue(), radix);
            tmp = q2;
        }
        StringBuilder buf = new StringBuilder(numGroups * digitsPerLong[radix] + 1);
        if (this.signum < 0) {
            buf.append('-');
        }
        buf.append(digitGroup[numGroups - 1]);
        int i = numGroups - 2;
        while (i >= 0) {
            int numLeadingZeros = digitsPerLong[radix] - digitGroup[i].length();
            if (numLeadingZeros != 0) {
                buf.append(zeros[numLeadingZeros]);
            }
            buf.append(digitGroup[i]);
            --i;
        }
        return buf.toString();
    }

    private static void toString(BigInteger u, StringBuilder sb, int radix, int digits) {
        if (u.mag.length <= 20) {
            String s = u.smallToString(radix);
            if (s.length() < digits && sb.length() > 0) {
                int i = s.length();
                while (i < digits) {
                    sb.append('0');
                    ++i;
                }
            }
            sb.append(s);
            return;
        }
        int b = u.bitLength();
        int n = (int)Math.round(Math.log((double)b * LOG_TWO / logCache[radix]) / LOG_TWO - 1.0);
        BigInteger v = BigInteger.getRadixConversionCache(radix, n);
        BigInteger[] results = u.divideAndRemainder(v);
        int expectedDigits = 1 << n;
        BigInteger.toString(results[0], sb, radix, digits - expectedDigits);
        BigInteger.toString(results[1], sb, radix, expectedDigits);
    }

    private static BigInteger getRadixConversionCache(int radix, int exponent) {
        BigInteger[] cacheLine = powerCache[radix];
        if (exponent < cacheLine.length) {
            return cacheLine[exponent];
        }
        int oldLength = cacheLine.length;
        cacheLine = BigInteger.Arrays_copyOfBigInteger(cacheLine, exponent + 1);
        int i = oldLength;
        while (i <= exponent) {
            cacheLine[i] = cacheLine[i - 1].pow(2);
            ++i;
        }
        BigInteger[][] pc = powerCache;
        if (exponent >= pc[radix].length) {
            pc = (BigInteger[][])pc.clone();
            pc[radix] = cacheLine;
            powerCache = pc;
        }
        return cacheLine[exponent];
    }

    public String toString() {
        return this.toString(10);
    }

    public byte[] toByteArray() {
        int byteLen = this.bitLength() / 8 + 1;
        byte[] byteArray = new byte[byteLen];
        int i = byteLen - 1;
        int bytesCopied = 4;
        int nextInt = 0;
        int intIndex = 0;
        while (i >= 0) {
            if (bytesCopied == 4) {
                nextInt = this.getInt(intIndex++);
                bytesCopied = 1;
            } else {
                nextInt >>>= 8;
                ++bytesCopied;
            }
            byteArray[i] = (byte)nextInt;
            --i;
        }
        return byteArray;
    }

    @Override
    public int intValue() {
        int result = 0;
        result = this.getInt(0);
        return result;
    }

    @Override
    public long longValue() {
        long result = 0L;
        int i = 1;
        while (i >= 0) {
            result = (result << 32) + ((long)this.getInt(i) & 0xFFFFFFFFL);
            --i;
        }
        return result;
    }

    @Override
    public float floatValue() {
        int twiceSignifFloor;
        if (this.signum == 0) {
            return 0.0f;
        }
        int exponent = (this.mag.length - 1 << 5) + BigInteger.bitLengthForInt(this.mag[0]) - 1;
        if (exponent < 63) {
            return this.longValue();
        }
        if (exponent > 127) {
            return this.signum > 0 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
        }
        int shift = exponent - 24;
        int nBits = shift & 0x1F;
        int nBits2 = 32 - nBits;
        if (nBits == 0) {
            twiceSignifFloor = this.mag[0];
        } else {
            twiceSignifFloor = this.mag[0] >>> nBits;
            if (twiceSignifFloor == 0) {
                twiceSignifFloor = this.mag[0] << nBits2 | this.mag[1] >>> nBits;
            }
        }
        int signifFloor = twiceSignifFloor >> 1;
        boolean increment = (twiceSignifFloor & 1) != 0 && (((signifFloor &= 0x7FFFFF) & 1) != 0 || this.abs().getLowestSetBit() < shift);
        int signifRounded = increment ? signifFloor + 1 : signifFloor;
        int bits = exponent + 127 << 23;
        bits += signifRounded;
        return Float.intBitsToFloat(bits |= this.signum & Integer.MIN_VALUE);
    }

    @Override
    public double doubleValue() {
        int lowBits;
        int highBits;
        if (this.signum == 0) {
            return 0.0;
        }
        int exponent = (this.mag.length - 1 << 5) + BigInteger.bitLengthForInt(this.mag[0]) - 1;
        if (exponent < 63) {
            return this.longValue();
        }
        if (exponent > 1023) {
            return this.signum > 0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        int shift = exponent - 53;
        int nBits = shift & 0x1F;
        int nBits2 = 32 - nBits;
        if (nBits == 0) {
            highBits = this.mag[0];
            lowBits = this.mag[1];
        } else {
            highBits = this.mag[0] >>> nBits;
            lowBits = this.mag[0] << nBits2 | this.mag[1] >>> nBits;
            if (highBits == 0) {
                highBits = lowBits;
                lowBits = this.mag[1] << nBits2 | this.mag[2] >>> nBits;
            }
        }
        long twiceSignifFloor = ((long)highBits & 0xFFFFFFFFL) << 32 | (long)lowBits & 0xFFFFFFFFL;
        long signifFloor = twiceSignifFloor >> 1;
        boolean increment = (twiceSignifFloor & 1L) != 0L && (((signifFloor &= 0xFFFFFFFFFFFFFL) & 1L) != 0L || this.abs().getLowestSetBit() < shift);
        long signifRounded = increment ? signifFloor + 1L : signifFloor;
        long bits = (long)(exponent + 1023) << 52;
        bits += signifRounded;
        return Double.longBitsToDouble(bits |= (long)this.signum & Long.MIN_VALUE);
    }

    private static int[] stripLeadingZeroInts(int[] val) {
        int vlen = val.length;
        int keep = 0;
        while (keep < vlen && val[keep] == 0) {
            ++keep;
        }
        return Arrays.copyOfRange(val, keep, vlen);
    }

    private static int[] trustedStripLeadingZeroInts(int[] val) {
        int vlen = val.length;
        int keep = 0;
        while (keep < vlen && val[keep] == 0) {
            ++keep;
        }
        return keep == 0 ? val : Arrays.copyOfRange(val, keep, vlen);
    }

    private static int[] stripLeadingZeroBytes(byte[] a) {
        int byteLength = a.length;
        int keep = 0;
        while (keep < byteLength && a[keep] == 0) {
            ++keep;
        }
        int intLength = byteLength - keep + 3 >>> 2;
        int[] result = new int[intLength];
        int b = byteLength - 1;
        int i = intLength - 1;
        while (i >= 0) {
            result[i] = a[b--] & 0xFF;
            int bytesRemaining = b - keep + 1;
            int bytesToTransfer = Math.min(3, bytesRemaining);
            int j = 8;
            while (j <= bytesToTransfer << 3) {
                int n = i;
                result[n] = result[n] | (a[b--] & 0xFF) << j;
                j += 8;
            }
            --i;
        }
        return result;
    }

    private static int[] makePositive(byte[] a) {
        int byteLength = a.length;
        int keep = 0;
        while (keep < byteLength && a[keep] == -1) {
            ++keep;
        }
        int k = keep;
        while (k < byteLength && a[k] == 0) {
            ++k;
        }
        int extraByte = k == byteLength ? 1 : 0;
        int intLength = byteLength - keep + extraByte + 3 >>> 2;
        int[] result = new int[intLength];
        int b = byteLength - 1;
        int i = intLength - 1;
        while (i >= 0) {
            result[i] = a[b--] & 0xFF;
            int numBytesToTransfer = Math.min(3, b - keep + 1);
            if (numBytesToTransfer < 0) {
                numBytesToTransfer = 0;
            }
            int j = 8;
            while (j <= 8 * numBytesToTransfer) {
                int n = i;
                result[n] = result[n] | (a[b--] & 0xFF) << j;
                j += 8;
            }
            int mask = -1 >>> 8 * (3 - numBytesToTransfer);
            result[i] = ~result[i] & mask;
            --i;
        }
        i = result.length - 1;
        while (i >= 0) {
            result[i] = (int)(((long)result[i] & 0xFFFFFFFFL) + 1L);
            if (result[i] != 0) break;
            --i;
        }
        return result;
    }

    private static int[] makePositive(int[] a) {
        int n;
        int keep = 0;
        while (keep < a.length && a[keep] == -1) {
            ++keep;
        }
        int j = keep;
        while (j < a.length && a[j] == 0) {
            ++j;
        }
        int extraInt = j == a.length ? 1 : 0;
        int[] result = new int[a.length - keep + extraInt];
        int i = keep;
        while (i < a.length) {
            result[i - keep + extraInt] = ~a[i];
            ++i;
        }
        i = result.length - 1;
        do {
            n = i--;
        } while ((result[n] = result[n] + 1) == 0);
        return result;
    }

    private int intLength() {
        return (this.bitLength() >>> 5) + 1;
    }

    private int signInt() {
        return this.signum < 0 ? -1 : 0;
    }

    private int getInt(int n) {
        if (n < 0) {
            return 0;
        }
        if (n >= this.mag.length) {
            return this.signInt();
        }
        int magInt = this.mag[this.mag.length - n - 1];
        return this.signum >= 0 ? magInt : (n <= this.firstNonzeroIntNum() ? -magInt : ~magInt);
    }

    private int firstNonzeroIntNum() {
        int fn = this.firstNonzeroIntNum - 2;
        if (fn == -2) {
            fn = 0;
            int mlen = this.mag.length;
            int i = mlen - 1;
            while (i >= 0 && this.mag[i] == 0) {
                --i;
            }
            fn = mlen - i - 1;
            this.firstNonzeroIntNum = fn + 2;
        }
        return fn;
    }

    public long longValueExact() {
        if (this.mag.length <= 2 && this.bitLength() <= 63) {
            return this.longValue();
        }
        throw new ArithmeticException("BigInteger out of long range");
    }

    public int intValueExact() {
        if (this.mag.length <= 1 && this.bitLength() <= 31) {
            return this.intValue();
        }
        throw new ArithmeticException("BigInteger out of int range");
    }

    public short shortValueExact() {
        int value;
        if (this.mag.length <= 1 && this.bitLength() <= 31 && (value = this.intValue()) >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            return this.shortValue();
        }
        throw new ArithmeticException("BigInteger out of short range");
    }

    public byte byteValueExact() {
        int value;
        if (this.mag.length <= 1 && this.bitLength() <= 31 && (value = this.intValue()) >= -128 && value <= 127) {
            return this.byteValue();
        }
        throw new ArithmeticException("BigInteger out of byte range");
    }

    static BigInteger[] Arrays_copyOfBigInteger(BigInteger[] original, int newLength) {
        BigInteger[] copy = new BigInteger[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }
}

