/*
 * Decompiled with CFR 0.152.
 */
package com.microej.http.util;

import ej.bon.Constants;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class HttpBufferedStreamFactory {
    private static final int MIN_RX_BUFFER_SIZE = 10;
    private static final String BUFFER_SIZE = ".buffer.size";
    private static final String JAVA_NET_HTTP_URL_CONNECTION = "java.net.HttpURLConnection.";
    private static final String RX_BUFFER_SIZE_CONSTANTE_NAME = "java.net.HttpURLConnection.rx.buffer.size";
    private static final String TX_BUFFER_SIZE_CONSTANTE_NAME = "java.net.HttpURLConnection.tx.buffer.size";

    private HttpBufferedStreamFactory() {
    }

    public static InputStream newInputStream(InputStream inputStream) {
        return new BufferedInputStream(inputStream, Math.max(Constants.getInt((String)RX_BUFFER_SIZE_CONSTANTE_NAME), 10));
    }

    public static OutputStream newOutputStream(OutputStream outputStream) {
        int bufferSize = Constants.getInt((String)TX_BUFFER_SIZE_CONSTANTE_NAME);
        if (bufferSize > 0) {
            return new BufferedOutputStream(outputStream, bufferSize);
        }
        return outputStream;
    }
}

