/*
 * Decompiled with CFR 0.152.
 */
package ej.motion.bounce;

import ej.bon.XMath;
import ej.motion.Motion;
import ej.motion.MotionManager;
import ej.motion.bounce.BounceEaseInMotion;
import ej.motion.bounce.BounceEaseInOutMotion;
import ej.motion.bounce.BounceEaseOutMotion;
import ej.motion.quad.QuadEaseOutMotion;
import ej.motion.util.TossHelper;

public class BounceMotionManager
implements MotionManager {
    @Override
    public Motion easeIn(int start, int stop, long duration) {
        return new BounceEaseInMotion(start, stop, duration);
    }

    @Override
    public Motion easeOut(int start, int stop, long duration) {
        return new BounceEaseOutMotion(start, stop, duration);
    }

    @Override
    public Motion easeInOut(int start, int stop, long duration) {
        return new BounceEaseInOutMotion(start, stop, duration);
    }

    @Override
    public Motion toss(int start, int min, int max, float initialSpeed, long duration) {
        int stop = TossHelper.computeExpectedStop(start, initialSpeed, duration);
        if ((stop = XMath.limit((int)stop, (int)min, (int)max)) == min || stop == max) {
            return new BounceEaseOutMotion(start, stop, duration);
        }
        return new QuadEaseOutMotion(start, stop, duration);
    }
}

