/*
 * Decompiled with CFR 0.152.
 */
package ej.restserver;

import ej.hoka.http.HTTPRequest;
import ej.hoka.http.HTTPResponse;
import ej.hoka.http.HTTPServer;
import ej.hoka.http.HTTPSession;
import ej.restserver.RequestHandler;
import ej.restserver.RestServer;

public class RestSession
extends HTTPSession {
    private final RestServer server;

    public RestSession(RestServer server) {
        super((HTTPServer)server);
        this.server = server;
    }

    protected HTTPResponse answer(HTTPRequest request) {
        for (RequestHandler handler : this.server.getRequestResolvers()) {
            HTTPResponse answer = handler.answer(this.server, request);
            if (answer == null) continue;
            return answer;
        }
        return HTTPResponse.RESPONSE_NOT_FOUND;
    }

    public static class Factory
    implements HTTPSession.Factory {
        public HTTPSession newHTTPSession(HTTPServer server) {
            if (!(server instanceof RestServer)) {
                throw new IllegalArgumentException("RestSession can only be used with RestServer.");
            }
            return new RestSession((RestServer)server);
        }
    }
}

