/*
 * Decompiled with CFR 0.152.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import ej.annotation.Nullable;
import ej.bluetooth.BluetoothAdapter;
import ej.bluetooth.BluetoothScanFilter;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Endpoint;
import java.io.IOException;

public class StartScanningEndpoint
implements Endpoint {
    private static final byte ACTION_NONE = 0;
    private static final byte ACTION_FIELD_EXISTS = 1;
    private static final byte ACTION_FIELD_EQUALS = 2;
    private static final byte ACTION_FIELD_STARTS_WITH = 3;
    private byte filterAction;
    private byte filterType;
    @Nullable
    private byte[] filterData;

    public String getName() {
        return "bluetooth_start_scanning";
    }

    public void readRequestBody(CommandReader reader) throws IOException {
        this.filterAction = (byte)reader.readInt();
        this.filterType = (byte)reader.readInt();
        this.filterData = reader.readByteArray();
    }

    public void writeResponseBody(CommandSender sender) throws IOException {
        BluetoothScanFilter scanFilter = this.createScanFilter();
        boolean success = scanFilter == null ? false : BluetoothAdapter.getAdapter().startScanning(scanFilter);
        if (success) {
            sender.sendInt(0);
        } else {
            sender.sendInt(1);
        }
    }

    @Nullable
    private BluetoothScanFilter createScanFilter() {
        switch (this.filterAction) {
            case 0: {
                return BluetoothScanFilter.noFilter();
            }
            case 1: {
                return BluetoothScanFilter.fieldExists((byte)this.filterType);
            }
            case 2: {
                assert (this.filterData != null);
                return BluetoothScanFilter.fieldEquals((byte)this.filterType, (byte[])this.filterData);
            }
            case 3: {
                assert (this.filterData != null);
                return BluetoothScanFilter.fieldStartsWith((byte)this.filterType, (byte[])this.filterData);
            }
        }
        return null;
    }
}

