/*
 * Decompiled with CFR 0.152.
 */
package ej.property;

import ej.property.PropertyLoader;
import ej.property.PropertyRegistry;
import ej.property.loader.SystemPropertyLoader;
import ej.property.registry.SimplePropertyRegistry;
import ej.service.loader.SystemPropertiesServiceLoader;

public class PropertyFactory {
    private static final PropertyRegistry PROPERTY_REGISTRY = PropertyFactory.getPropertyRegistryInstance();
    private static final PropertyLoader PROPERTY_LOADER = PropertyFactory.getPropertyLoaderInstance();

    private PropertyFactory() {
    }

    private static PropertyLoader getPropertyLoaderInstance() {
        SystemPropertiesServiceLoader propertiesServiceLoader = new SystemPropertiesServiceLoader();
        PropertyLoader propertyLoaderCandidate = (PropertyLoader)propertiesServiceLoader.getService(PropertyLoader.class);
        if (propertyLoaderCandidate != null) {
            return propertyLoaderCandidate;
        }
        return new SystemPropertyLoader();
    }

    private static PropertyRegistry getPropertyRegistryInstance() {
        SystemPropertiesServiceLoader propertiesServiceLoader = new SystemPropertiesServiceLoader();
        PropertyRegistry propertyRegistryCandidate = (PropertyRegistry)propertiesServiceLoader.getService(PropertyRegistry.class);
        if (propertyRegistryCandidate != null) {
            return propertyRegistryCandidate;
        }
        return new SimplePropertyRegistry();
    }

    public static PropertyLoader getPropertyLoader() {
        return PROPERTY_LOADER;
    }

    public static PropertyRegistry getPropertyRegistry() {
        return PROPERTY_REGISTRY;
    }
}

