/*
 * Decompiled with CFR 0.152.
 */
package java.time.zone;

import ej.annotation.Nullable;
import java.time.ZoneId;
import java.time.zone.ZoneRules;
import java.time.zone.ZoneRulesException;
import java.time.zone.ZoneRulesProvider;
import java.util.HashSet;
import java.util.NavigableMap;
import java.util.Set;

class DefaultZoneRulesProvider
extends ZoneRulesProvider {
    private static final String GMT = "GMT";

    DefaultZoneRulesProvider() {
    }

    @Override
    protected Set<String> provideZoneIds() {
        HashSet<String> set = new HashSet<String>(1);
        set.add(GMT);
        return set;
    }

    @Override
    @Nullable
    protected ZoneRules provideRules(String zoneId, boolean forCaching) {
        if (GMT.equals(zoneId)) {
            return ZoneId.of(GMT).getRules();
        }
        throw new ZoneRulesException("Unknown time-zone ID: " + zoneId);
    }

    @Override
    protected NavigableMap<String, ZoneRules> provideVersions(String zoneId) {
        throw new ZoneRulesException("No history available for this zone ID " + zoneId);
    }
}

