/*
 * Decompiled with CFR 0.152.
 */
package com.microej.tool.classextender;

import com.microej.tool.classextender.helper.ClassPoolHelper;
import com.microej.tool.classextender.helper.ExtendClassFilter;
import com.microej.tool.classextender.helper.ExtensionClassLoader;
import com.microej.tool.classextender.helper.JarUpdater;
import com.microej.tool.classextender.helper.MethodHelper;
import ej.basictool.annotation.Extend;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;

public class ClassExtender {
    public static boolean includeDefaultClasspath;
    private static final Logger LOGGER;
    private static final String TMP_DIR_PREFIX = "class_exender";
    private final String outputDirectoryPath;

    static {
        LOGGER = Logger.getLogger(ClassExtender.class.getName());
    }

    public static void main(String ... args) throws IOException {
        String stringClasspath = args[0];
        String stringSourceJarPath = args[1];
        LOGGER.log(Level.INFO, "Apply extensions from {0} to {1}", new Object[]{stringClasspath, stringSourceJarPath});
        File[] classpath = (File[])Arrays.stream(stringClasspath.split(File.pathSeparator)).map(path -> new File((String)path)).toArray(File[]::new);
        File sourceJarPath = new File(stringSourceJarPath);
        ClassExtender extender = args.length >= 3 ? new ClassExtender(new File(args[2])) : new ClassExtender();
        File modifiedJar = extender.extend(sourceJarPath, classpath);
        if (args.length == 2) {
            Files.copy(modifiedJar.toPath(), sourceJarPath.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public ClassExtender() throws IOException {
        this.outputDirectoryPath = Files.createTempDirectory(TMP_DIR_PREFIX, new FileAttribute[0]).toString();
    }

    public ClassExtender(File outputDirectory) {
        this.outputDirectoryPath = outputDirectory.toString();
    }

    public File extend(File jar, File ... extensionClasspath) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ExtensionClassLoader extensionClassLoader = new ExtensionClassLoader(extensionClasspath);){
            List<Class<?>> extensions = extensionClassLoader.findClasses(new ExtendClassFilter(extensionClasspath));
            File extendedJar = this.getJarCopy(jar);
            JarUpdater jarUpdater = new JarUpdater(extendedJar);
            ClassExtender extender = new ClassExtender();
            File[] fullClasspath = new File[extensionClasspath.length + 1];
            System.arraycopy(extensionClasspath, 0, fullClasspath, 0, extensionClasspath.length);
            fullClasspath[extensionClasspath.length] = extendedJar;
            Throwable throwable2 = null;
            Object var12_15 = null;
            try (ClassPoolHelper pool = new ClassPoolHelper(fullClasspath);){
                ArrayList<CtClass> extensionClasses = new ArrayList<CtClass>(extensions.size());
                for (Class<?> extension : extensions) {
                    try {
                        CtClass ctExtensionClass = pool.getClass(extension.getName());
                        extensionClasses.add(ctExtensionClass);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        LOGGER.log(Level.SEVERE, "Could not apply extension {0} on {1}", new Object[]{extension.getName(), extendedJar.getName()});
                    }
                }
                try {
                    Set<File> extendedClassFiles = extender.extend(extensionClasses, fullClasspath);
                    jarUpdater.update(extendedClassFiles.toArray(new File[0]));
                }
                catch (ClassNotFoundException e) {
                    LOGGER.log(Level.WARNING, "Could not apply extensions on {0}:  {1}", new Object[]{extendedJar.getName(), e.getMessage()});
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            return extendedJar;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private File getJarCopy(File jar) {
        File jarCopy = new File(this.outputDirectoryPath, jar.getName());
        if (!jarCopy.exists()) {
            try {
                Files.copy(jar.toPath(), jarCopy.toPath(), new CopyOption[0]);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.SEVERE, "Could not copy {0} to target directory", jar.getName());
                return null;
            }
        }
        return jarCopy;
    }

    public Set<File> extend(String className, File ... classpath) throws ClassNotFoundException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ClassPoolHelper pool = new ClassPoolHelper(classpath);){
            CtClass ctExtensionClass = pool.getClass(className);
            return this.extend(Collections.singletonList(ctExtensionClass), classpath);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Set<File> extend(List<CtClass> ctExtensionClasses, File ... classpath) throws ClassNotFoundException {
        HashSet<File> extendedClassFiles = new HashSet<File>();
        HashMap<CtClass, ArrayList<MethodHelper>> extensions = new HashMap<CtClass, ArrayList<MethodHelper>>();
        Throwable throwable = null;
        Object var6_7 = null;
        try (ClassPoolHelper pool = new ClassPoolHelper(classpath);){
            for (CtClass ctClass : ctExtensionClasses) {
                CtMethod[] ctMethodArray = ctClass.getMethods();
                int n = ctMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    block23: {
                        CtMethod ctMethod = ctMethodArray[n2];
                        if (ctMethod.getDeclaringClass() == ctClass) {
                            Extend annotation;
                            try {
                                annotation = (Extend)ctMethod.getAnnotation(Extend.class);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                break block23;
                            }
                            MethodHelper method = new MethodHelper(ctMethod);
                            if (annotation != null) {
                                if (!method.isStatic()) {
                                    LOGGER.log(Level.WARNING, "Did not use {0} as extension: only static methods can be used.", method.node.getName());
                                } else {
                                    String baseClassName = annotation.className();
                                    CtClass baseClass = pool.getClass(baseClassName);
                                    ArrayList<MethodHelper> methods = (ArrayList<MethodHelper>)extensions.get(baseClass);
                                    if (methods == null) {
                                        methods = new ArrayList<MethodHelper>();
                                        extensions.put(baseClass, methods);
                                    }
                                    methods.add(method);
                                }
                            }
                        }
                    }
                    ++n2;
                }
            }
            for (Map.Entry entry : extensions.entrySet()) {
                for (MethodHelper method : (List)entry.getValue()) {
                    CtClass baseClass = (CtClass)entry.getKey();
                    baseClass.defrost();
                    LOGGER.log(Level.INFO, "Add {0} to {1}", new Object[]{method.node.getName(), baseClass.getName()});
                    try {
                        CtMethod methodCopy = new CtMethod(method.node, baseClass, null);
                        MethodHelper methodHelper = new MethodHelper(methodCopy);
                        if (!method.keepStatic()) {
                            methodHelper.removeStatic();
                            methodHelper.removeFirstArgumentFromDescriptor();
                        }
                        baseClass.addMethod(methodCopy);
                        extendedClassFiles.add(this.write(baseClass));
                    }
                    catch (Exception e) {
                        LOGGER.severe(e.getMessage());
                        e.printStackTrace();
                    }
                }
                ((CtClass)entry.getKey()).detach();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return extendedClassFiles;
    }

    private File write(CtClass baseClass) throws IOException {
        try {
            baseClass.writeFile(this.outputDirectoryPath);
            return new File(this.classFileNameFromPath(this.outputDirectoryPath, baseClass.getName()));
        }
        catch (CannotCompileException cannotCompileException) {
            LOGGER.log(Level.SEVERE, "Could not write {0} extension", baseClass.getSimpleName());
            return null;
        }
    }

    private String classFileNameFromPath(String classpath, String className) {
        return String.valueOf(classpath) + File.separatorChar + className.replace('.', File.separatorChar) + ".class";
    }
}

