/*
 * Decompiled with CFR 0.152.
 */
package ej.fp;

import ej.fp.Widget;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;

public class Composite
extends Widget
implements Iterable<Widget> {
    private final List<Widget> widgets = new ArrayList<Widget>(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Composite composite = this;
        synchronized (composite) {
            for (Widget widget : this) {
                try {
                    widget.dispose();
                }
                catch (Exception exception) {}
            }
            super.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Widget widget) throws IllegalArgumentException {
        if (widget != null) {
            Composite composite = this;
            synchronized (composite) {
                if (widget.getParent() != null) {
                    throw new IllegalArgumentException("Widget is already available in the hierarchy.");
                }
                widget.setParent(this);
                this.widgets.add(widget);
            }
        }
    }

    @Override
    public Iterator<Widget> iterator() {
        return new WidgetIterator(this);
    }

    private static class WidgetIterator
    implements Iterator<Widget> {
        private final Deque<Iterator<Widget>> stack = new ArrayDeque<Iterator<Widget>>();

        WidgetIterator(Composite composite) {
            this.stack.push(composite.widgets.iterator());
        }

        @Override
        public boolean hasNext() {
            for (Iterator<Widget> iterator : this.stack) {
                if (!iterator.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Widget next() {
            Iterator<Widget> iterator = this.stack.peek();
            if (iterator.hasNext()) {
                Widget widget = iterator.next();
                if (widget instanceof Composite) {
                    iterator = ((Composite)widget).widgets.iterator();
                    this.stack.push(iterator);
                }
                return widget;
            }
            this.stack.pop();
            return this.next();
        }
    }
}

