/*
 * Decompiled with CFR 0.152.
 */
package ej.fp.widget;

import ej.fp.Widget;
import ej.fp.util.ThirdEventThread;
import ej.fp.widget.Button;
import ej.microui.event.EventButton;

@Widget.WidgetDescription(attributes={@Widget.WidgetAttribute(name="label"), @Widget.WidgetAttribute(name="x"), @Widget.WidgetAttribute(name="y"), @Widget.WidgetAttribute(name="skin"), @Widget.WidgetAttribute(name="pushedSkin"), @Widget.WidgetAttribute(name="longPeriod", isOptional=true), @Widget.WidgetAttribute(name="filter", isOptional=true), @Widget.WidgetAttribute(name="listenerClass", isOptional=true)})
public class LongButton
extends Button
implements ThirdEventThread.ThirdEventWidget {
    private final ThirdEventThread longThread = new ThirdEventThread(this, false);
    private int longPeriod = 500;

    public void setLongPeriod(int longPeriod) {
        if (longPeriod <= 0) {
            throw new IllegalArgumentException("Long period cannot be negative.");
        }
        this.longPeriod = longPeriod;
    }

    @Override
    public void setListenerClass(String listenerClassName) {
        this.setListenerClass(LongButtonListener.class, listenerClassName);
    }

    @Override
    public void start() {
        super.start();
        this.longThread.start();
    }

    @Override
    public void dispose() {
        this.longThread.dispose();
        super.dispose();
    }

    @Override
    protected Object newDefaultListener() {
        return new LongButtonListenerToButtonEvents();
    }

    @Override
    public void sendThirdEvent() {
        ((LongButtonListener)this.getListener()).pressLong(this);
    }

    @Override
    public int getSleepPeriod() {
        return this.longPeriod;
    }

    @Override
    protected void press() {
        ThirdEventThread longThread = this.longThread;
        if (!longThread.isSendingThirdEvent()) {
            super.press();
            longThread.wakeup();
        }
    }

    @Override
    protected void release() {
        this.longThread.goToSleep();
        super.release();
    }

    public static interface LongButtonListener
    extends Button.ButtonListener {
        public void pressLong(LongButton var1);
    }

    public static class LongButtonListenerToButtonEvents
    extends Button.ButtonListenerToButtonEvents
    implements LongButtonListener {
        @Override
        public void pressLong(LongButton widget) {
            EventButton.sendLongEvent((String)this.getMicroUIGeneratorTag(), (int)widget.getID());
        }
    }
}

