/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http.body;

import ej.hoka.http.body.BodyParser;
import ej.hoka.http.body.HttpPart;
import java.io.IOException;
import java.io.InputStream;

public class MultiPartBodyParser
implements BodyParser<MultiPartBody> {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final String BUFFER_SIZE_PROPERTY = "hoka.buffer.size";
    public static final String BOUNDARY = "boundary=";

    @Override
    public MultiPartBody parseBody(InputStream inputStream, String contentType) throws IOException {
        MultiPartBuffer buffer = null;
        if (contentType != null && contentType.startsWith("multipart/form-data")) {
            String boundary = contentType.substring(contentType.indexOf(59) + 1);
            buffer = new MultiPartBuffer();
            buffer.boundary = "\r\n--" + boundary.substring(boundary.indexOf(BOUNDARY) + BOUNDARY.length());
            buffer.stream = inputStream;
            buffer.buffer = new byte[Integer.getInteger(BUFFER_SIZE_PROPERTY, 4096).intValue()];
            ((MultiPartBuffer)buffer).buffer[0] = 13;
            ((MultiPartBuffer)buffer).buffer[1] = 10;
            buffer.lengthAvailable = 2;
        }
        return new MultiPartBody(buffer);
    }

    public static class MultiPartBody {
        private final MultiPartBuffer buffer;

        private MultiPartBody(MultiPartBuffer buffer) {
            this.buffer = buffer;
        }

        public HttpPart nextPart() throws IOException {
            if (this.buffer != null && this.buffer.hasData()) {
                HttpPart httpPart = new HttpPart(this.buffer);
                if (httpPart.parseHeaders().size() == 0 && !this.buffer.hasData()) {
                    httpPart.close();
                    httpPart = null;
                }
                return httpPart;
            }
            return null;
        }
    }

    static class MultiPartBuffer {
        private InputStream stream;
        private String boundary;
        private byte[] buffer;
        private int offset;
        private int lengthAvailable;

        MultiPartBuffer() {
        }

        public boolean hasData() throws IOException {
            return this.buffer != null && this.boundary != null && (this.lengthAvailable > 0 || this.stream != null && this.stream.available() > 0);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            this.buffer(len);
            int read = -1;
            int toRead = len;
            int boundaryIndex = this.getBoundaryIndex(toRead);
            toRead = boundaryIndex != -1 ? boundaryIndex : Math.min(toRead, this.lengthAvailable - this.boundary.length());
            if (toRead > 0) {
                System.arraycopy(this.buffer, this.offset, b, off, toRead);
                this.offset += toRead;
                this.lengthAvailable -= toRead;
                read = toRead;
            }
            return read;
        }

        public int read() throws IOException {
            this.buffer(1);
            int read = this.buffer[this.offset] & 0xFF;
            ++this.offset;
            --this.lengthAvailable;
            return read;
        }

        public void skipToBoundary() throws IOException {
            this.buffer(1);
            int boundaryIndex = this.getBoundaryIndex(this.lengthAvailable);
            int boundaryLength = this.boundary.length();
            while (boundaryIndex == -1 && (this.lengthAvailable > 0 || this.stream != null && this.stream.available() > 0)) {
                System.arraycopy(this.buffer, this.offset + this.lengthAvailable - boundaryLength, this.buffer, 0, boundaryLength);
                this.lengthAvailable = boundaryLength;
                this.offset = 0;
                boundaryIndex = this.getBoundaryIndex(this.lengthAvailable);
            }
            if (boundaryIndex != -1) {
                int offset = boundaryIndex + boundaryLength + 2;
                this.offset += offset;
                this.lengthAvailable -= offset;
            }
        }

        public int getBoundaryIndex(int length) throws IOException {
            this.buffer(1);
            byte[] buffer = this.buffer;
            String bufferAsString = new String(buffer, "US-ASCII");
            int max = Math.min(length, this.lengthAvailable - 1 - this.boundary.length());
            int index = this.offset - 1;
            while ((index = bufferAsString.indexOf(13, index + 1)) != -1 && index < max) {
                if (!bufferAsString.startsWith(this.boundary, index)) continue;
                return index - this.offset;
            }
            return -1;
        }

        private void buffer(int length) throws IOException {
            int lengthAvailable = this.lengthAvailable;
            if (this.stream != null && lengthAvailable - this.boundary.length() - 1 < length) {
                int read;
                int offset = this.offset;
                int bufferLength = this.buffer.length;
                if (offset != 0) {
                    System.arraycopy(this.buffer, offset, this.buffer, 0, lengthAvailable);
                }
                if ((read = this.stream.read(this.buffer, lengthAvailable, bufferLength - lengthAvailable)) > 0) {
                    this.lengthAvailable += read;
                }
                this.offset = 0;
            }
        }
    }
}

