/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http;

import ej.basictool.map.PackedMap;
import ej.hoka.http.body.BodyParser;
import ej.hoka.http.body.ParameterParser;
import ej.hoka.http.encoding.ContentEncoding;
import ej.hoka.http.encoding.EncodingRegistry;
import ej.hoka.http.encoding.HttpUnsupportedEncodingException;
import ej.hoka.http.encoding.TransferEncoding;
import ej.hoka.http.support.UrlDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class HttpRequest {
    private static final int INITIAL_STRING_BUILDER_CAPACITY = 16;
    public static final int POST = 1;
    public static final int GET = 2;
    public static final int PUT = 3;
    public static final int DELETE = 4;
    public static final int HEAD = 5;
    public static final int CONNECT = 6;
    public static final int OPTIONS = 7;
    public static final int TRACE = 8;
    public static final int PATCH = 9;
    protected static final int BEFORE_ALL = 10;
    protected static final int BEFORE = 11;
    protected static final int AFTER = 12;
    protected static final int AFTER_ALL = 13;
    private static final char SPACE_CHAR = ' ';
    private static final char PERCENTAGE_CHAR = '%';
    private static final char COLON_CHAR = ':';
    private static final String RESPONSE_COLON = ": ";
    private static final char NEWLINE_CHAR = '\n';
    private static final char CARRIAGE_RETURN_CHAR = '\r';
    private static final char TABULATION_CHAR = '\t';
    private static final char QUESTION_MARK_CHAR = '?';
    private static final String MALFORMED_HTTP_REQUEST = "Malformed HTTP Request";
    private static final String CONNECTION_LOST = "Connection lost";
    private static final int INITIAL_MAP_CAPACITY = 10;
    private static final int INITIAL_URI_CAPACITY = 64;
    private static final int VERSION_SIZE = 10;
    private final int method;
    private final String uri;
    private final Map<String, String> queryParameters;
    private final Map<String, String> pathParameters;
    private final List<String> splatParameters;
    private final PackedMap<String, Object> attributes;
    private final String version;
    private final Map<String, String> headers;
    private final InputStream body;
    private Map<String, String> cookies;

    protected HttpRequest(InputStream inputStream, EncodingRegistry encodingRegistry) throws IOException {
        this.method = HttpRequest.parseMethod(inputStream);
        this.queryParameters = new HashMap<String, String>(10);
        this.pathParameters = new HashMap<String, String>(0);
        this.splatParameters = new ArrayList<String>(0);
        this.attributes = new PackedMap();
        this.uri = HttpRequest.parseURI(inputStream, this.queryParameters);
        this.version = HttpRequest.parseVersion(inputStream);
        this.headers = HttpRequest.parseHeaderFields(inputStream);
        this.body = this.getContentEncodingStream(inputStream, encodingRegistry);
    }

    public int getMethod() {
        return this.method;
    }

    public String getURI() {
        return this.uri;
    }

    public Map<String, String> getQueryParams() {
        return Collections.unmodifiableMap(this.queryParameters);
    }

    public String getQueryParam(String name) {
        return this.queryParameters.get(name);
    }

    public String getPathParam(String param) {
        String key = !param.startsWith(":") ? ":" + param.toLowerCase() : param.toLowerCase();
        return this.pathParameters.get(key);
    }

    public List<String> getSplatParams() {
        return Collections.unmodifiableList(this.splatParameters);
    }

    protected void addSplatParameters(List<String> splatParameters) {
        this.splatParameters.addAll(splatParameters);
    }

    protected void addPathParameters(Map<String, String> parameters) {
        this.pathParameters.putAll(parameters);
    }

    public Object getAttribute(String key) {
        return this.attributes.get((Object)key);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put((Object)key, value);
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public String getHeader(String name) {
        if (name == null) {
            return null;
        }
        return this.headers.get(name.toLowerCase());
    }

    public Map<String, String> getCookies() {
        if (this.cookies == null) {
            this.cookies = HttpRequest.parseCookies(this.headers.get("cookie"));
        }
        return this.cookies;
    }

    public String getCookie(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        return this.getCookies().get(name);
    }

    public <T> T parseBody(BodyParser<T> bodyParser) throws IOException {
        return bodyParser.parseBody(this.body, this.getHeader("content-type"));
    }

    public InputStream getRequestBody() {
        return this.body;
    }

    private InputStream getContentEncodingStream(InputStream in, EncodingRegistry encodingRegistry) throws IOException {
        String transferEncoding = this.getHeader("transfer-encoding");
        TransferEncoding transferCodingHandler = encodingRegistry.getTransferEncoding(transferEncoding);
        if (transferCodingHandler == null) {
            throw new HttpUnsupportedEncodingException("501 Not Implemented", "transfer-encoding: " + transferEncoding);
        }
        in = transferCodingHandler.open(this, in);
        String contentEncoding = this.getHeader("content-encoding");
        if (contentEncoding != null) {
            ContentEncoding handler = encodingRegistry.getContentEncoding(contentEncoding);
            if (handler == null) {
                throw new HttpUnsupportedEncodingException("501 Not Implemented", "transfer-encoding: " + contentEncoding);
            }
            in = handler.open(in);
        }
        return in;
    }

    private static int parseMethod(InputStream input) throws IOException {
        String inputMethod;
        int read;
        StringBuilder builder = new StringBuilder();
        while ((read = input.read()) != 32) {
            if (read == -1) {
                throw new IOException(CONNECTION_LOST);
            }
            builder.append((char)read);
        }
        switch (inputMethod = builder.toString().toUpperCase()) {
            case "GET": {
                return 2;
            }
            case "POST": {
                return 1;
            }
            case "PUT": {
                return 3;
            }
            case "DELETE": {
                return 4;
            }
            case "HEAD": {
                return 5;
            }
            case "CONNECT": {
                return 6;
            }
            case "OPTIONS": {
                return 7;
            }
            case "TRACE": {
                return 8;
            }
            case "PATCH": {
                return 9;
            }
        }
        throw new IllegalArgumentException(MALFORMED_HTTP_REQUEST);
    }

    private static String parseURI(InputStream input, Map<String, String> parameters) throws IOException {
        StringBuilder sb = new StringBuilder(Math.min(64, input.available()));
        block5: while (true) {
            int i;
            if ((i = input.read()) == -1) {
                throw new IOException(CONNECTION_LOST);
            }
            switch (i) {
                case 63: {
                    ParameterParser.parseParameters(input, parameters);
                    break block5;
                }
                case 32: {
                    break block5;
                }
                case 37: {
                    i = UrlDecoder.decode(input, sb);
                }
                default: {
                    sb.append((char)i);
                    continue block5;
                }
            }
            break;
        }
        return sb.toString();
    }

    private static String parseVersion(InputStream input) throws IOException {
        byte[] version = new byte[10];
        int readBytes = 0;
        while (readBytes < 10) {
            int r = input.read(version, readBytes, 10 - readBytes);
            if (r == -1) {
                throw new IOException(CONNECTION_LOST);
            }
            readBytes += r;
        }
        return new String(version, 0, 8);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Map<String, String> parseHeaderFields(InputStream input) throws IOException {
        HashMap<String, String> header = new HashMap<String, String>(10);
        StringBuilder sbKey = new StringBuilder(16);
        StringBuilder sbValue = new StringBuilder(16);
        StringBuilder curBuffer = sbKey;
        boolean pendingSpace = false;
        int i = input.read();
        block6: while (true) {
            if (i == -1) {
                throw new IOException(CONNECTION_LOST);
            }
            switch (i) {
                case 37: {
                    if (curBuffer != sbKey) break;
                    throw new IllegalArgumentException(MALFORMED_HTTP_REQUEST);
                }
                case 58: {
                    if (curBuffer != sbKey) break;
                    curBuffer = sbValue;
                    i = input.read();
                    continue block6;
                }
                case 9: 
                case 32: {
                    pendingSpace = true;
                    i = input.read();
                    continue block6;
                }
                case 13: {
                    i = input.read();
                    if (i != 10) {
                        throw new IllegalArgumentException(MALFORMED_HTTP_REQUEST);
                    }
                    if (sbKey.length() == 0 && sbValue.length() == 0) {
                        return header;
                    }
                    i = input.read();
                    if (i == -1) {
                        throw new IOException(CONNECTION_LOST);
                    }
                    if (i == 32 || i == 9) continue block6;
                    if (sbKey.charAt(sbKey.length() - 1) != '*') {
                        header.put(sbKey.toString().toLowerCase(), sbValue.toString());
                    }
                    sbValue.delete(0, sbValue.length());
                    sbKey.delete(0, sbKey.length());
                    curBuffer = sbKey;
                    continue block6;
                }
            }
            if (pendingSpace) {
                pendingSpace = false;
                if (curBuffer.length() > 0) {
                    curBuffer.append(' ');
                }
            }
            curBuffer.append((char)i);
            i = input.read();
        }
    }

    private static Map<String, String> parseCookies(String cookiesHeader) {
        if (cookiesHeader == null || cookiesHeader.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> cookies = new HashMap<String, String>();
        StringTokenizer cookieParser = new StringTokenizer(cookiesHeader.trim(), ";");
        while (cookieParser.hasMoreTokens()) {
            String cookie = cookieParser.nextToken().trim();
            int keyValueSeparatorIndex = cookie.indexOf(61);
            String key = cookie.substring(0, keyValueSeparatorIndex);
            String value = cookie.substring(keyValueSeparatorIndex + 1);
            if (key == null || key.isEmpty()) continue;
            cookies.put(key, value);
        }
        return cookies;
    }
}

