/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.container;

import ej.mwt.Container;
import ej.mwt.Widget;
import ej.mwt.util.Size;

public class Grid
extends Container {
    private boolean orientation;
    private int count;

    public Grid(boolean orientation, int count) {
        if (count <= 0) {
            throw new IllegalArgumentException();
        }
        this.orientation = orientation;
        this.count = count;
    }

    public void setOrientation(boolean orientation) {
        this.orientation = orientation;
    }

    public boolean getOrientation() {
        return this.orientation;
    }

    public void setCount(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException();
        }
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public Widget getCellChild(int column, int row) {
        int index = this.orientation ? row * this.count + column : column * this.count + row;
        if (index < 0 || index >= this.getChildrenCount()) {
            throw new IndexOutOfBoundsException();
        }
        return this.getChild(index);
    }

    public void addChild(Widget child) {
        super.addChild(child);
    }

    public void removeChild(Widget child) {
        super.removeChild(child);
    }

    public void insertChild(Widget child, int index) {
        super.insertChild(child, index);
    }

    public void replaceChild(int index, Widget child) {
        super.replaceChild(index, child);
    }

    public void removeAllChildren() {
        super.removeAllChildren();
    }

    protected void computeContentOptimalSize(Size size) {
        int childrenCount = this.getChildrenCount();
        if (childrenCount == 0) {
            size.setSize(0, 0);
            return;
        }
        boolean isHorizontal = this.orientation;
        int mainCount = this.count;
        int otherCount = Grid.getOtherCount(childrenCount, mainCount);
        int columns = isHorizontal ? mainCount : otherCount;
        int rows = isHorizontal ? otherCount : mainCount;
        int widthHint = size.getWidth();
        int heightHint = size.getHeight();
        int childWidthHint = widthHint == 0 ? 0 : widthHint / columns;
        int childHeightHint = heightHint == 0 ? 0 : heightHint / rows;
        int maxCellWidth = 0;
        int maxCellHeight = 0;
        Widget[] widgetArray = this.getChildren();
        int n = widgetArray.length;
        int n2 = 0;
        while (n2 < n) {
            Widget widget = widgetArray[n2];
            assert (widget != null);
            this.computeChildOptimalSize(widget, childWidthHint, childHeightHint);
            maxCellWidth = Math.max(maxCellWidth, widget.getWidth());
            maxCellHeight = Math.max(maxCellHeight, widget.getHeight());
            ++n2;
        }
        size.setSize(maxCellWidth * columns, maxCellHeight * rows);
    }

    protected void layOutChildren(int contentWidth, int contentHeight) {
        int childrenCount = this.getChildrenCount();
        if (childrenCount == 0) {
            return;
        }
        boolean isHorizontal = this.orientation;
        int mainContentLength = isHorizontal ? contentWidth : contentHeight;
        int otherContentLength = isHorizontal ? contentHeight : contentWidth;
        int mainCount = this.count;
        int otherCount = Grid.getOtherCount(childrenCount, mainCount);
        Widget[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            Widget child = children[i];
            assert (child != null);
            int otherPosition = i / mainCount;
            int mainPosition = i - otherPosition * mainCount;
            int mainStart = mainPosition * mainContentLength / mainCount;
            int mainEnd = (mainPosition + 1) * mainContentLength / mainCount;
            int otherStart = otherPosition * otherContentLength / otherCount;
            int otherEnd = (otherPosition + 1) * otherContentLength / otherCount;
            if (isHorizontal) {
                this.layOutChild(child, mainStart, otherStart, mainEnd - mainStart, otherEnd - otherStart);
            } else {
                this.layOutChild(child, otherStart, mainStart, otherEnd - otherStart, mainEnd - mainStart);
            }
            ++i;
        }
    }

    private static int getOtherCount(int totalCount, int mainCount) {
        return (totalCount + mainCount - 1) / mainCount;
    }
}

