/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.swipe;

import ej.annotation.Nullable;
import ej.bon.Util;
import ej.bon.XMath;
import ej.motion.Function;
import ej.motion.Motion;
import ej.motion.quart.QuartEaseOutFunction;
import ej.mwt.Widget;
import ej.mwt.animation.Animation;
import ej.mwt.animation.Animator;
import ej.widget.event.PointerEventHandler;
import ej.widget.motion.MotionAnimation;
import ej.widget.motion.MotionAnimationListener;
import ej.widget.swipe.SwipeListener;
import ej.widget.swipe.Swipeable;

public class SwipeEventHandler
extends PointerEventHandler {
    private static final int RELEASE_WITH_NO_MOVE_DELAY = 200;
    private static final float HALF = 0.5f;
    public static final int DEFAULT_DURATION = 800;
    private final int size;
    private final boolean cyclic;
    private final boolean horizontal;
    private final Swipeable swipeable;
    private final int itemInterval;
    @Nullable
    private final int[] itemsSize;
    private final Animator animator;
    @Nullable
    private Animation draggedAnimation;
    @Nullable
    private MotionAnimation releasedAnimation;
    @Nullable
    private SwipeListener swipeListener;
    private long duration;
    private Function motionFunction;
    private boolean pressed;
    private int initialValue;
    private int pressX;
    private int pressY;
    private int pressCoordinate;
    private long pressTime;
    private int previousCoordinate;
    private long lastTime;
    private int totalShift;
    private boolean forward;
    private int currentValue;
    private int draggedValue;
    private boolean dragged;
    private boolean swipeStarted;

    public SwipeEventHandler(Widget widget, int size, boolean cyclic, boolean horizontal, Swipeable swipeable, Animator animator) {
        this(widget, SwipeEventHandler.checkSize(size), cyclic, 0, null, horizontal, swipeable, animator);
    }

    public SwipeEventHandler(Widget widget, int itemCount, int itemInterval, boolean cyclic, boolean horizontal, Swipeable swipeable, Animator animator) {
        this(widget, itemCount, itemInterval, cyclic, false, horizontal, swipeable, animator);
    }

    public SwipeEventHandler(Widget widget, int itemCount, int itemInterval, boolean cyclic, boolean snapToItem, boolean horizontal, Swipeable swipeable, Animator animator) {
        this(widget, SwipeEventHandler.computeSize(itemCount, itemInterval, cyclic), cyclic, snapToItem ? itemInterval : 0, null, horizontal, swipeable, animator);
    }

    public SwipeEventHandler(Widget widget, int[] itemsSize, boolean cyclic, boolean snapToItem, boolean horizontal, Swipeable swipeable, Animator animator) {
        this(widget, SwipeEventHandler.computeSize(itemsSize, cyclic), cyclic, snapToItem ? 1 : 0, itemsSize, horizontal, swipeable, animator);
    }

    private SwipeEventHandler(Widget widget, int size, boolean cyclic, int itemInterval, @Nullable int[] itemsSize, boolean horizontal, Swipeable swipeable, Animator animator) {
        super(widget);
        assert (swipeable != null);
        this.size = size;
        this.cyclic = cyclic;
        this.itemInterval = itemInterval;
        this.itemsSize = (int[])(itemsSize != null ? (int[])itemsSize.clone() : null);
        this.horizontal = horizontal;
        this.swipeable = swipeable;
        this.animator = animator;
        this.duration = 800L;
        this.motionFunction = QuartEaseOutFunction.INSTANCE;
    }

    private static int checkSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException();
        }
        return size;
    }

    private static int computeSize(int itemCount, int itemInterval, boolean cyclic) {
        return (SwipeEventHandler.checkSize(itemCount) - (cyclic ? 0 : 1)) * SwipeEventHandler.checkSize(itemInterval);
    }

    private static int computeSize(int[] itemsSize, boolean cyclic) {
        SwipeEventHandler.checkSize(itemsSize.length);
        int totalSize = 0;
        int[] nArray = itemsSize;
        int n = itemsSize.length;
        int n2 = 0;
        while (n2 < n) {
            int size = nArray[n2];
            totalSize += SwipeEventHandler.checkSize(size);
            ++n2;
        }
        if (!cyclic) {
            totalSize -= itemsSize[itemsSize.length - 1];
        }
        return totalSize;
    }

    public int getCurrentPosition() {
        return this.currentValue;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setMotionFunction(Function motionFunction) {
        this.motionFunction = motionFunction;
    }

    public void setSwipeListener(@Nullable SwipeListener swipeListener) {
        this.swipeListener = swipeListener;
    }

    public void stop() {
        this.stopAnimations();
        this.notifyStopSwipe();
    }

    private int getCoordinate(int x, int y) {
        if (this.horizontal) {
            return x;
        }
        return y;
    }

    private void updateCurrentStep(int currentStep) {
        if (this.cyclic) {
            currentStep = this.modulo(currentStep, this.size);
        }
        if (this.currentValue != currentStep) {
            this.currentValue = currentStep;
            this.swipeable.onMove(currentStep);
        }
    }

    @Override
    protected boolean onPressed(int pointerX, int pointerY) {
        int pressCoordinate;
        this.stop();
        this.pressed = true;
        this.pressTime = Util.platformTimeMillis();
        this.pressX = pointerX;
        this.pressY = pointerY;
        this.pressCoordinate = pressCoordinate = this.getCoordinate(pointerX, pointerY);
        this.previousCoordinate = pressCoordinate;
        this.initialValue = this.currentValue;
        this.totalShift = 0;
        this.dragged = false;
        return false;
    }

    @Override
    protected boolean onDragged(int pointerX, int pointerY) {
        long currentTime;
        int pointerCoordinate = this.getCoordinate(pointerX, pointerY);
        if (!this.pressed) {
            return this.onPressed(pointerX, pointerY);
        }
        this.lastTime = currentTime = Util.platformTimeMillis();
        int shift = pointerCoordinate - this.previousCoordinate;
        boolean dragged = this.isDragged(pointerX, pointerY, shift);
        this.dragged |= dragged;
        if (dragged) {
            boolean currentForward;
            this.totalShift += shift;
            this.draggedValue = this.initialValue - this.totalShift;
            this.previousCoordinate = pointerCoordinate;
            boolean bl = currentForward = shift > 0;
            if (this.totalShift != 0 && currentForward != this.forward) {
                this.pressCoordinate = pointerCoordinate;
                this.pressTime = currentTime;
                this.forward = currentForward;
            }
        }
        return dragged;
    }

    private boolean isDragged(int pointerX, int pointerY, int shift) {
        boolean dragged;
        if (!this.dragged) {
            int shiftX = Math.abs(pointerX - this.pressX);
            int shiftY = Math.abs(pointerY - this.pressY);
            boolean bl = this.horizontal ? shiftX > shiftY : (dragged = shiftY > shiftX);
            if (dragged) {
                Animation draggedAnimation;
                this.notifyStartSwipe();
                this.draggedAnimation = draggedAnimation = new Animation(){

                    public boolean tick(long platformTimeMillis) {
                        int current;
                        int target = SwipeEventHandler.this.draggedValue;
                        int next = Math.abs(target - (current = SwipeEventHandler.this.currentValue)) <= 1 ? target : (target + current) / 2;
                        SwipeEventHandler.this.updateCurrentStep(next);
                        return SwipeEventHandler.this.pressed;
                    }
                };
                this.animator.startAnimation(draggedAnimation);
            } else if (this.horizontal) {
                this.pressY = pointerY;
            } else {
                this.pressX = pointerX;
            }
        } else {
            dragged = shift != 0;
        }
        return dragged;
    }

    @Override
    protected boolean onReleased(int pointerX, int pointerY) {
        long delay;
        int stop;
        int currentValue = this.currentValue;
        long duration = this.duration;
        int pointerCoordinate = this.getCoordinate(pointerX, pointerY);
        if (this.dragged) {
            long currentTime = Util.platformTimeMillis();
            int limitedStep = this.limit(currentValue);
            if (!this.cyclic && limitedStep != currentValue) {
                stop = limitedStep;
                delay = duration / 2L;
            } else if (currentTime - this.lastTime < 200L) {
                float speed = -((float)(pointerCoordinate - this.pressCoordinate)) / (float)(2L * (currentTime - this.pressTime));
                stop = (int)((float)currentValue + speed * (float)duration);
                delay = duration;
            } else {
                stop = currentValue;
                delay = duration / 2L;
            }
        } else {
            stop = currentValue;
            delay = duration / 2L;
        }
        if (!this.cyclic) {
            stop = this.limit(stop);
        }
        this.pressed = false;
        this.moveTo(stop, delay);
        return this.dragged;
    }

    @Override
    protected void onExited() {
        if (!(this.dragged || this.currentValue >= 0 && this.currentValue <= this.size)) {
            this.moveTo(this.limit(this.currentValue), this.duration / 2L);
        }
    }

    public int limit(int position) {
        return XMath.limit((int)position, (int)0, (int)this.size);
    }

    public void moveTo(int position) {
        this.stopAnimations();
        this.updateCurrentStep(this.snap(position));
    }

    private int snap(int position) {
        int itemInterval = this.itemInterval;
        int[] itemsSize = this.itemsSize;
        if (itemsSize != null && itemInterval != 0) {
            int currentSize = position / this.size * this.size;
            int[] nArray = itemsSize;
            int n = itemsSize.length;
            int n2 = 0;
            while (n2 < n) {
                int itemSize = nArray[n2];
                int nextSize = itemSize + currentSize;
                if (position < nextSize) {
                    if (position - currentSize < nextSize - position) {
                        return currentSize;
                    }
                    return nextSize;
                }
                currentSize = nextSize;
                ++n2;
            }
        } else if (itemInterval != 0) {
            return (int)((float)position / (float)itemInterval + 0.5f) * itemInterval;
        }
        return position;
    }

    public void moveTo(int stop, long duration) {
        this.stopAnimations();
        stop = this.snap(stop);
        if (stop == this.currentValue) {
            this.notifyStopSwipe();
            return;
        }
        Motion moveMotion = new Motion(this.motionFunction, this.currentValue, stop, duration);
        MotionAnimationListener motionListener = new MotionAnimationListener(){

            @Override
            public void tick(int value, boolean finished) {
                SwipeEventHandler.this.updateCurrentStep(value);
                if (finished) {
                    SwipeEventHandler.this.notifyStopSwipe();
                    SwipeEventHandler.this.releasedAnimation = null;
                }
            }
        };
        this.notifyStartSwipe();
        this.releasedAnimation = new MotionAnimation(this.animator, moveMotion, motionListener);
        this.releasedAnimation.start();
    }

    public void moveToBeginning() {
        this.moveTo(0);
    }

    public void moveToBeginning(long duration) {
        this.moveTo(0, duration);
    }

    public void moveToEnd() {
        this.moveTo(this.size);
    }

    public void moveToEnd(long duration) {
        this.moveTo(this.size, duration);
    }

    private void stopAnimations() {
        MotionAnimation releasedAnimation;
        Animation draggedAnimation = this.draggedAnimation;
        if (draggedAnimation != null) {
            this.animator.stopAnimation(draggedAnimation);
            this.draggedAnimation = null;
        }
        if ((releasedAnimation = this.releasedAnimation) != null) {
            releasedAnimation.stop();
            this.releasedAnimation = null;
        }
    }

    private int modulo(int index, int length) {
        if ((index %= length) < 0) {
            index += length;
        }
        return index;
    }

    private void notifyStartSwipe() {
        if (!this.swipeStarted) {
            this.swipeStarted = true;
            SwipeListener swipeListener = this.swipeListener;
            if (swipeListener != null) {
                swipeListener.onSwipeStarted();
            }
        }
    }

    private void notifyStopSwipe() {
        if (this.swipeStarted) {
            SwipeListener swipeListener = this.swipeListener;
            if (swipeListener != null) {
                swipeListener.onSwipeStopped();
            }
            this.swipeStarted = false;
        }
    }
}

