/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.stylesheet;

import ej.mwt.Widget;
import ej.mwt.style.Style;
import ej.mwt.stylesheet.Stylesheet;

public class CachedStylesheet
implements Stylesheet {
    private static final int DEFAULT_SIZE = 10;
    private final Stylesheet stylesheet;
    private final Style[] stylesCache;
    private byte stylesCount;

    public CachedStylesheet(Stylesheet stylesheet) {
        this(stylesheet, 10);
    }

    public CachedStylesheet(Stylesheet stylesheet, int size) {
        this.stylesheet = stylesheet;
        this.stylesCache = new Style[size];
    }

    @Override
    public Style getStyle(Widget widget) {
        Style style = this.stylesheet.getStyle(widget);
        int styleHashCode = style.hashCode();
        Style[] stylesCache = this.stylesCache;
        int stylesCount = this.stylesCount;
        int i = 0;
        while (i < stylesCount) {
            Style cachedStyle = stylesCache[i];
            assert (cachedStyle != null);
            if (styleHashCode == cachedStyle.hashCode() && style.equals(cachedStyle)) {
                if (i != 0) {
                    stylesCache[i] = stylesCache[i - 1];
                    stylesCache[i - 1] = cachedStyle;
                }
                return cachedStyle;
            }
            ++i;
        }
        int half = stylesCount >> 1;
        System.arraycopy(stylesCache, half, stylesCache, half + 1, Math.min(stylesCount, stylesCache.length - 1) - half);
        stylesCache[half] = style;
        if (stylesCount != stylesCache.length) {
            stylesCount = (byte)(stylesCount + 1);
        }
        this.stylesCount = (byte)stylesCount;
        return style;
    }
}

